/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.AbstractBrowseImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath.SrcImageResource;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageContainer;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageElement;

final class SrcPackageImageContainer
implements IImageContainer {
    private final IPackageFragment m_packageFragment;
    private final SrcImageResource[] m_resources;

    public SrcPackageImageContainer(String id, IPackageFragmentRoot packageFragmentRoot, IPackageFragment packageFragment) throws Exception {
        this.m_packageFragment = packageFragment;
        ArrayList<SrcImageResource> resources = new ArrayList<SrcImageResource>();
        Object[] nonJavaResources = this.m_packageFragment.getNonJavaResources();
        int i = 0;
        while (i < nonJavaResources.length) {
            IFile resource;
            String extension;
            Object nonJavaResource = nonJavaResources[i];
            if (nonJavaResource instanceof IFile && AbstractBrowseImagePage.isImageExtension(extension = (resource = (IFile)nonJavaResource).getLocation().getFileExtension())) {
                SrcImageResource imageResource = new SrcImageResource(id, packageFragmentRoot, resource);
                resources.add(imageResource);
            }
            ++i;
        }
        this.m_resources = resources.toArray(new SrcImageResource[resources.size()]);
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    }

    public String getName() {
        return this.m_packageFragment.getElementName();
    }

    public IImageElement[] elements() {
        return this.m_resources;
    }

    boolean isEmpty() {
        return this.m_resources.length == 0;
    }

    void dispose() {
        int i = 0;
        while (i < this.m_resources.length) {
            SrcImageResource resource = this.m_resources[i];
            resource.dispose();
            ++i;
        }
    }
}

