/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class UiUtils {
    public static String KEY_IGNORE_HIERARCHY_ENABLED = "Ignore this Control when set 'enabled' property for hierarchy";
    private static Map m_extensionToIcon = new TreeMap();

    public static void runModalShell(Shell shell) {
        Display display = shell.getDisplay();
        shell.open();
        while (!shell.isDisposed() && shell.getVisible()) {
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Throwable throwable) {}
        }
    }

    public static void centerShell(Shell parentShell, Shell shell) {
        Point size = shell.getSize();
        Rectangle parentBounds = parentShell.getBounds();
        int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
        int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
        shell.setLocation(x, y);
    }

    public static void setVisibleAll(Combo combo) {
        UiUtils.setVisibleItemCount(combo, combo.getItemCount());
    }

    public static void setVisibleItemCount(Combo combo, int count) {
        combo.setVisibleItemCount(count);
        combo.getParent().layout();
    }

    public static void showAndDisposeOnHide(final Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuHidden(MenuEvent e) {
                e.display.asyncExec(new Runnable(){

                    public void run() {
                        menu.dispose();
                    }
                });
            }
        });
        menu.setVisible(true);
    }

    public static void addFocusListenerForControlTree(Control control, FocusListener focusListener) {
        control.addFocusListener(focusListener);
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                UiUtils.addFocusListenerForControlTree(child, focusListener);
                ++i;
            }
        }
    }

    public static boolean hasFocusInControlTree(Control control) {
        if (control.isDisposed()) {
            return false;
        }
        if (control.isFocusControl()) {
            return true;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (UiUtils.hasFocusInControlTree(child)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isChildOf(Widget parent, Widget child) {
        if (child instanceof Control) {
            Control childControl = (Control)child;
            while (childControl != null) {
                if (childControl == parent) {
                    return true;
                }
                childControl = childControl.getParent();
            }
        }
        return false;
    }

    public static int getColumnUnderCursor(Table table) {
        Point p = Display.getCurrent().getCursorLocation();
        p = table.toControl(p);
        return UiUtils.getColumnAt(table, p);
    }

    public static int getColumnAt(Table table, Point p) {
        int x = -table.getHorizontalBar().getSelection();
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            int width = column.getWidth();
            if (x <= p.x && p.x < x + width) {
                return i;
            }
            x += width;
            ++i;
        }
        return -1;
    }

    public static void installTableTooltipProvider(final Table table, final ITableTooltipProvider provider) {
        final Shell tableShell = table.getShell();
        final Listener tipControlListener = new Listener(){

            public void handleEvent(Event event) {
                Control tipControl = (Control)event.widget;
                Shell tipShell = tipControl.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)tipControl.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                    }
                    case 7: {
                        tipShell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            private Shell m_tipShell = null;
            private Control m_tipControl = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.m_tipShell == null) break;
                        this.m_tipShell.dispose();
                        this.m_tipShell = null;
                        this.m_tipControl = null;
                        break;
                    }
                    case 32: {
                        Point hoverLocation = new Point(event.x, event.y);
                        TableItem item = table.getItem(hoverLocation);
                        if (item == null) break;
                        if (this.m_tipShell != null && !this.m_tipShell.isDisposed()) {
                            this.m_tipShell.dispose();
                        }
                        this.m_tipShell = new Shell(tableShell, 16388);
                        this.m_tipShell.setLayout((Layout)new FillLayout());
                        int column = UiUtils.getColumnAt(table, hoverLocation);
                        this.m_tipControl = provider.createTooltipControl(item, (Composite)this.m_tipShell, column);
                        if (this.m_tipControl == null) break;
                        this.m_tipControl.setData("_TABLEITEM", (Object)item);
                        this.m_tipControl.addListener(7, tipControlListener);
                        this.m_tipControl.addListener(3, tipControlListener);
                        Point size = this.m_tipShell.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point p = table.toDisplay(new Point(rect.x, rect.y));
                        this.m_tipShell.setBounds(p.x, p.y, size.x, size.y);
                        this.m_tipShell.setVisible(true);
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
    }

    public static void expandAll(Tree tree) {
        UiUtils.setExpanded(tree.getItems(), true);
    }

    public static void collapseAll(Tree tree) {
        UiUtils.setExpanded(tree.getItems(), false);
    }

    private static void setExpanded(TreeItem[] treeItems, boolean expanded) {
        int i = 0;
        while (i < treeItems.length) {
            TreeItem treeItem = treeItems[i];
            treeItem.setExpanded(expanded);
            UiUtils.setExpanded(treeItem.getItems(), expanded);
            ++i;
        }
    }

    public static TreeItem[] getExpanded(Tree tree) {
        ArrayList expandedItems = new ArrayList();
        UiUtils.addExpanded(expandedItems, tree.getItems());
        return expandedItems.toArray(new TreeItem[expandedItems.size()]);
    }

    private static void addExpanded(List expandedItems, TreeItem[] treeItems) {
        int i = 0;
        while (i < treeItems.length) {
            TreeItem treeItem = treeItems[i];
            if (treeItem.getExpanded()) {
                expandedItems.add(treeItem);
            }
            UiUtils.addExpanded(expandedItems, treeItem.getItems());
            ++i;
        }
    }

    public static void setExpandedByData(Tree tree, Object[] expandedElements) {
        tree.setRedraw(false);
        try {
            UiUtils.setExpandedByData(tree.getItems(), expandedElements);
        }
        finally {
            tree.setRedraw(true);
        }
    }

    private static void setExpandedByData(TreeItem[] treeItems, Object[] expandedElements) {
        int i = 0;
        while (i < treeItems.length) {
            TreeItem treeItem = treeItems[i];
            boolean expand = ArrayUtils.contains((Object[])expandedElements, (Object)treeItem.getData());
            treeItem.setExpanded(expand);
            UiUtils.setExpandedByData(treeItem.getItems(), expandedElements);
            ++i;
        }
    }

    public static Rectangle getBoundsRelativeTo(Control control, Composite target) {
        Rectangle bounds = control.getBounds();
        return UiUtils.convertFromTo(bounds, (Control)control.getParent(), (Control)target);
    }

    public static Rectangle convertFromTo(Rectangle bounds, Control source, Control target) {
        Point p = source.toDisplay(new Point(bounds.x, bounds.y));
        p = target.toControl(p);
        bounds.x = p.x;
        bounds.y = p.y;
        return bounds;
    }

    public static void changeControlEnable(Control control, boolean enable) {
        if (control.getData(KEY_IGNORE_HIERARCHY_ENABLED) != null) {
            return;
        }
        if (control.getEnabled() != enable) {
            control.setEnabled(enable);
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                UiUtils.changeControlEnable(child, enable);
                ++i;
            }
        }
    }

    public static Image getCopy(Image image) {
        return image == null ? null : new Image(null, image.getImageData());
    }

    public static void drawScaledImage(GC gc, Image image, Rectangle targetRectangle) {
        int newImageHeight;
        int newImageWidth;
        int imageWidth = image.getBounds().width;
        int imageHeight = image.getBounds().height;
        if (imageWidth <= targetRectangle.width && imageHeight <= targetRectangle.height) {
            newImageWidth = imageWidth;
            newImageHeight = imageHeight;
        } else {
            double k_w = (double)targetRectangle.width / (double)imageWidth;
            double k_h = (double)targetRectangle.height / (double)imageHeight;
            double k = Math.min(k_w, k_h);
            newImageWidth = (int)((double)imageWidth * k);
            newImageHeight = (int)((double)imageHeight * k);
        }
        int destX = targetRectangle.x + (targetRectangle.width - newImageWidth) / 2;
        int destY = targetRectangle.y + (targetRectangle.height - newImageHeight) / 2;
        gc.drawImage(image, 0, 0, imageWidth, imageHeight, destX, destY, newImageWidth, newImageHeight);
    }

    public static Image getCroppedImage(Image fullImage, Rectangle cropBounds) {
        Rectangle fullImageBounds = fullImage.getBounds();
        int fullWidth = fullImageBounds.width;
        int fullHeight = fullImageBounds.height;
        int cropWidth = Math.max(Math.min(cropBounds.width, fullWidth - cropBounds.x), 1);
        int cropHeight = Math.max(Math.min(cropBounds.height, fullHeight - cropBounds.y), 1);
        Image croppedImage = new Image((Device)Display.getCurrent(), cropWidth, cropHeight);
        GC gc = new GC((Drawable)croppedImage);
        try {
            try {
                gc.drawImage(fullImage, cropBounds.x, cropBounds.y, cropWidth, cropHeight, 0, 0, cropWidth, cropHeight);
            }
            catch (Throwable e) {
                String message = "fullImage.getBounds()=" + fullImageBounds + " cropBounds=" + cropBounds;
                throw new Error(message, e);
            }
        }
        finally {
            gc.dispose();
            fullImage.dispose();
        }
        return croppedImage;
    }

    public static boolean equals(Image image_1, Image image_2) {
        if (ObjectUtils.equals((Object)image_1, (Object)image_2)) {
            return true;
        }
        if (!image_1.getBounds().equals((Object)image_2.getBounds())) {
            return false;
        }
        ImageData imageData_1 = image_1.getImageData();
        ImageData imageData_2 = image_2.getImageData();
        if (imageData_1.depth != imageData_2.depth) {
            return false;
        }
        int i = 0;
        while (i < imageData_1.data.length) {
            if (imageData_1.data[i] != imageData_2.data[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Image getIcon(String extension) {
        ImageData imageData;
        Program program;
        Image icon = (Image)m_extensionToIcon.get(extension);
        if (icon == null && (program = Program.findProgram((String)extension)) != null && (imageData = program.getImageData()) != null) {
            icon = new Image((Device)Display.getDefault(), imageData);
            m_extensionToIcon.put(extension, icon);
        }
        return icon;
    }

    public static void openWarning(Shell parent, String title, String message) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static void openError(Shell parent, String title, String message) {
        MessageDialog dialog = new MessageDialog(parent, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    public static interface ITableTooltipProvider {
        public Control createTooltipControl(TableItem var1, Composite var2, int var3);
    }
}

