/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IDialogFieldListener;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;

public final class ProjectSelectionDialogField
extends StringButtonDialogField
implements IDialogFieldListener {
    private IJavaProject m_project;
    private IDialogFieldListener m_updateListener;

    public static ProjectSelectionDialogField create() {
        ButtonAdapter adapter = new ButtonAdapter();
        ProjectSelectionDialogField field = new ProjectSelectionDialogField(adapter);
        adapter.setReceiver(field);
        return field;
    }

    private ProjectSelectionDialogField(IStringButtonAdapter adapter) {
        super(adapter);
        this.setDialogFieldListener(this);
    }

    public IJavaProject getProject() {
        return this.m_project;
    }

    public void setProject(IJavaProject project) {
        this.m_project = project;
        if (this.m_project != null) {
            String newText = ProjectSelectionDialogField.getProjectString(this.m_project);
            if (!this.getText().equals(newText)) {
                this.setText(newText);
            }
        }
        if (this.m_updateListener != null) {
            this.m_updateListener.dialogFieldChanged(this);
        }
    }

    public void setUpdateListener(IDialogFieldListener updateListener) {
        this.m_updateListener = updateListener;
        this.setDialogFieldListener(this);
    }

    public void dialogFieldChanged(DialogField field) {
        this.setProject(ProjectSelectionDialogField.getProjectFromString(this.getText()));
    }

    private static String getProjectString(IJavaProject project) {
        return project == null ? "" : project.getPath().makeRelative().toString();
    }

    private static IJavaProject getProjectFromString(String projectString) {
        if (projectString.length() == 0) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = workspaceRoot.getProject(projectString);
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return javaProject.exists() ? javaProject : null;
    }

    private static class ButtonAdapter
    implements IStringButtonAdapter {
        private ProjectSelectionDialogField m_receiver;

        private ButtonAdapter() {
        }

        public void setReceiver(ProjectSelectionDialogField receiver) {
            this.m_receiver = receiver;
        }

        public void changeControlPressed(DialogField field) {
            IJavaProject project = this.selectProject(this.m_receiver.m_project);
            if (project != null) {
                this.m_receiver.setProject(project);
            }
        }

        private IJavaProject selectProject(IJavaProject initialSelection) {
            Object[] objects;
            Shell shell = Display.getCurrent().getActiveShell();
            JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
            StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider();
            ListDialog dialog = new ListDialog(shell);
            dialog.setContentProvider((IStructuredContentProvider)contentProvider);
            dialog.setLabelProvider((ILabelProvider)labelProvider);
            dialog.setTitle(Messages.ProjectSelectionDialogField_dialogTitle);
            dialog.setMessage(Messages.ProjectSelectionDialogField_dialogMessage);
            dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
            dialog.setInitialSelections(new Object[]{initialSelection});
            if (dialog.open() == 0 && (objects = dialog.getResult()) != null && objects.length == 1) {
                return (IJavaProject)objects[0];
            }
            return null;
        }
    }
}

