/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import org.eclipse.wb.internal.core.utils.GenericTypeError;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericTypeResolver {
    protected final GenericTypeResolver m_parent;
    public static GenericTypeResolver EMPTY = new GenericTypeResolver(null);

    public GenericTypeResolver(GenericTypeResolver parent) {
        this.m_parent = parent;
    }

    public String resolve(Type typeToResolve) {
        WildcardType wildcardType;
        Type[] upperBounds;
        String result;
        if (typeToResolve instanceof Class) {
            return ((Class)typeToResolve).getCanonicalName();
        }
        if (typeToResolve instanceof TypeVariable && (result = this.resolveTypeVariable((TypeVariable)typeToResolve)) != null) {
            return result;
        }
        if (typeToResolve instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeToResolve;
            StringBuilder buffer = new StringBuilder();
            buffer.append(((Class)parameterizedType.getRawType()).getName());
            buffer.append("<");
            boolean firstTypeArgument = true;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type = typeArray[n2];
                if (firstTypeArgument) {
                    firstTypeArgument = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(GenericsUtils.getTypeName(this, type));
                ++n2;
            }
            buffer.append(">");
            return buffer.toString();
        }
        if (typeToResolve instanceof WildcardType && (upperBounds = (wildcardType = (WildcardType)typeToResolve).getUpperBounds()).length == 1) {
            return GenericsUtils.getTypeName(this, upperBounds[0]);
        }
        if (this.m_parent != null) {
            return this.m_parent.resolve(typeToResolve);
        }
        throw new GenericTypeError("Can not resolve actual type for: " + typeToResolve);
    }

    protected String resolveTypeVariable(TypeVariable<?> variable) {
        return null;
    }

    public static GenericTypeResolver superClass(final GenericTypeResolver parent, Class<?> actualClass, Class<?> declarationClass) {
        if (actualClass != declarationClass) {
            Type superGeneric = actualClass.getGenericSuperclass();
            if (superGeneric instanceof ParameterizedType) {
                ParameterizedType superParameterized = (ParameterizedType)superGeneric;
                final Map<String, Type> typeArguments = GenericTypeResolver.getTypeArguments(superGeneric);
                GenericTypeResolver thisClassResolver = new GenericTypeResolver(parent){

                    @Override
                    protected String resolveTypeVariable(TypeVariable<?> variable) {
                        String variableName = variable.getName();
                        Type variableType = (Type)typeArguments.get(variableName);
                        return parent.resolve(variableType);
                    }
                };
                return GenericTypeResolver.superClass(thisClassResolver, (Class)superParameterized.getRawType(), declarationClass);
            }
            return GenericTypeResolver.superClass(parent, actualClass.getSuperclass(), declarationClass);
        }
        return parent;
    }

    public static GenericTypeResolver fixed(final String name, Class<?> clazz) {
        final String clazzName = ReflectionUtils.getCanonicalName(clazz);
        return new GenericTypeResolver(EMPTY){

            @Override
            protected String resolveTypeVariable(TypeVariable<?> variable) {
                if (variable.getName().equals(name)) {
                    return clazzName;
                }
                return null;
            }
        };
    }

    public static GenericTypeResolver argumentOfMethod(final GenericTypeResolver parent, Method method, int index) {
        Type genericParameter = method.getGenericParameterTypes()[index];
        final Map<String, Type> typeArguments = GenericTypeResolver.getTypeArguments(genericParameter);
        return new GenericTypeResolver(parent){

            @Override
            protected String resolveTypeVariable(TypeVariable<?> variable) {
                String variableName = variable.getName();
                Type variableType = (Type)typeArguments.get(variableName);
                if (variableType != null) {
                    return parent.resolve(variableType);
                }
                return null;
            }
        };
    }

    private static Map<String, Type> getTypeArguments(Type type) {
        Map typeArguments = Maps.newTreeMap();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterized.getActualTypeArguments();
            Class generic = (Class)parameterized.getRawType();
            TypeVariable<Class<T>>[] typeParameters = generic.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable typeParameter = typeParameters[i];
                typeArguments.put(typeParameter.getName(), actualTypeArguments[i]);
                ++i;
            }
        }
        return typeArguments;
    }
}

