/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.preferences.code;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.preferences.IPreferenceConstants;
import org.eclipse.wb.internal.core.preferences.Messages;
import org.eclipse.wb.internal.core.preferences.bind.AbstractBindingPreferencesPage;
import org.eclipse.wb.internal.core.utils.binding.DataBindManager;
import org.eclipse.wb.internal.core.utils.ui.AbstractBindingComposite;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TabFactory;
import org.eclipse.wb.internal.core.utils.ui.TableFactory;

public abstract class VariablesPreferencePage
extends AbstractBindingPreferencesPage
implements IPreferenceConstants {
    public VariablesPreferencePage(ToolkitDescription toolkit) {
        super(toolkit);
    }

    protected AbstractBindingComposite createBindingComposite(Composite parent) {
        return new ContentsComposite(parent, this.m_bindManager, this.m_toolkit);
    }

    private static class ContentsComposite
    extends AbstractBindingComposite {
        private final ToolkitDescription m_toolkit;
        private List<NamesManager.ComponentNameDescription> m_descriptions;
        private TableViewer m_namesViewer;
        private static final Image IMAGE_FALSE = DesignerPlugin.getImage("preferences/boolean_false.png");
        private static final Image IMAGE_TRUE = DesignerPlugin.getImage("preferences/boolean_true.png");

        public ContentsComposite(Composite parent, DataBindManager bindManager, ToolkitDescription toolkit) {
            super(parent, bindManager, toolkit.getPreferences());
            this.m_toolkit = toolkit;
            GridLayoutFactory.create(this).noMargins();
            TabFolder tabFolder = new TabFolder((Composite)this, 0);
            GridDataFactory.create((Control)tabFolder).grab().fill();
            Composite composite = TabFactory.item(tabFolder).text(Messages.VariablesPreferencePage_typeSpecificTab).composite();
            this.createTypeSpecificPage(composite);
            composite = TabFactory.item(tabFolder).text(Messages.VariablesPreferencePage_autoRenameTab).composite();
            this.createAutoRenamePage(composite);
            composite = TabFactory.item(tabFolder).text(Messages.VariablesPreferencePage_miscTab).composite();
            this.createMiscellaneousPage(composite);
        }

        protected String validate() throws Exception {
            String template = this.getString("textVariable.template");
            String message = NamesManager.validate(template);
            if (message != null) {
                return MessageFormat.format(Messages.VariablesPreferencePage_validateVariableNameTemplate, message);
            }
            return super.validate();
        }

        private void createAutoRenamePage(Composite parent) {
            GridLayoutFactory.create(parent).columns(2).equalColumns();
            new Label(parent, 0).setText(Messages.VariablesPreferencePage_arLabel);
            Combo modeCombo = new Combo(parent, 8);
            GridDataFactory.create((Control)modeCombo).grabH().fillH();
            modeCombo.setItems(new String[]{Messages.VariablesPreferencePage_arAlways, Messages.VariablesPreferencePage_arDefault, Messages.VariablesPreferencePage_arNever});
            this.bindSelection(modeCombo, "textVariable.mode");
            new Label(parent, 0).setText(Messages.VariablesPreferencePage_arPatternLabel);
            Combo templateCombo = new Combo(parent, 0);
            GridDataFactory.create((Control)templateCombo).grabH().fillH();
            templateCombo.setItems(new String[]{"${text}${class_name}", "${class_acronym}${text}", "${class_name}${text}"});
            this.bindString(templateCombo, "textVariable.template");
            Composite composite = new Composite(parent, 0);
            GridDataFactory.create((Control)composite).spanH(2).fillH();
            GridLayoutFactory.create(composite).columns(3).noMargins();
            new Label(composite, 0).setText(Messages.VariablesPreferencePage_arLimitWords1);
            Text wordsText = new Text(composite, 2048);
            GridDataFactory.create((Control)wordsText).hintHC(3);
            this.bindInteger(wordsText, "textVariable.wordsLimit");
            new Label(composite, 0).setText(Messages.VariablesPreferencePage_arLimitWords2);
            Label templateHint = new Label(parent, 64);
            GridDataFactory.create((Control)templateHint).spanH(2);
            templateHint.setText(String.valueOf(Messages.VariablesPreferencePage_arHint1) + Messages.VariablesPreferencePage_arHint2 + Messages.VariablesPreferencePage_arHint3 + Messages.VariablesPreferencePage_arHint4 + Messages.VariablesPreferencePage_arHint5);
        }

        private void createMiscellaneousPage(Composite parent) {
            GridLayoutFactory.create(parent).columns(2).equalColumns();
            this.checkButton(parent, Messages.VariablesPreferencePage_miscRememberName, "putNameIntoComponent");
        }

        private void createTypeSpecificPage(Composite parent) {
            GridLayoutFactory.create(parent).columns(2);
            this.m_namesViewer = new TableViewer(parent, 67588);
            GridDataFactory.create((Control)this.m_namesViewer.getTable()).grab().fill();
            Table table = this.m_namesViewer.getTable();
            TableFactory tableFactory = TableFactory.modify(this.m_namesViewer);
            tableFactory.linesVisible(true).headerVisible(true);
            tableFactory.newColumn().text(Messages.VariablesPreferencePage_tsClassColumn).widthC(35);
            tableFactory.newColumn().text(Messages.VariablesPreferencePage_tsDefaultNameColumn).widthC(20);
            tableFactory.newColumn().text(Messages.VariablesPreferencePage_tsAcronymColumn).widthC(15);
            tableFactory.newColumn().text(Messages.VariablesPreferencePage_tsAsFieldColumn).widthC(15);
            this.m_namesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.m_namesViewer.setLabelProvider((IBaseLabelProvider)new NamesLabelProvider());
            this.m_namesViewer.setColumnProperties(new String[]{"class", "name", "acronym", "asField"});
            CellEditor[] cellEditorArray = new CellEditor[4];
            cellEditorArray[1] = new TextCellEditor((Composite)table);
            cellEditorArray[2] = new TextCellEditor((Composite)table);
            cellEditorArray[3] = new CheckboxCellEditor((Composite)table);
            this.m_namesViewer.setCellEditors(cellEditorArray);
            this.m_namesViewer.setCellModifier((ICellModifier)new NamesCellModifier());
            Composite buttonsComposite = new Composite(parent, 0);
            GridDataFactory.create((Control)buttonsComposite).grabV().alignVT();
            GridLayoutFactory.create(buttonsComposite).noMargins();
            Button addButton = new Button(buttonsComposite, 0);
            GridDataFactory.create((Control)addButton).fillH();
            addButton.setText(Messages.VariablesPreferencePage_tsAddButton);
            addButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    InputDialog inputDialog = new InputDialog(ContentsComposite.this.getShell(), Messages.VariablesPreferencePage_tsAddTitle, Messages.VariablesPreferencePage_tsAddMessage, "", null);
                    if (inputDialog.open() == 0) {
                        String className = inputDialog.getValue();
                        NamesManager.ComponentNameDescription description = NamesManager.getDefaultNameDescription(className);
                        ContentsComposite.this.m_descriptions.add(description);
                        ContentsComposite.this.m_namesViewer.add((Object)description);
                        ContentsComposite.this.m_namesViewer.setSelection((ISelection)new StructuredSelection((Object)description));
                    }
                }
            });
            final Button removeButton = new Button(buttonsComposite, 0);
            GridDataFactory.create((Control)removeButton).fillH();
            removeButton.setText(Messages.VariablesPreferencePage_tsRemove);
            removeButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    NamesManager.ComponentNameDescription description = (NamesManager.ComponentNameDescription)((IStructuredSelection)ContentsComposite.this.m_namesViewer.getSelection()).getFirstElement();
                    if (MessageDialog.openConfirm((Shell)ContentsComposite.this.getShell(), (String)Messages.VariablesPreferencePage_tsRemoveTitle, (String)MessageFormat.format(Messages.VariablesPreferencePage_tsRemoveMessage, description.getClassName()))) {
                        ContentsComposite.this.m_descriptions.remove(description);
                        ContentsComposite.this.m_namesViewer.remove((Object)description);
                    }
                }
            });
            removeButton.setEnabled(false);
            this.m_namesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    removeButton.setEnabled(!event.getSelection().isEmpty());
                }
            });
            this.m_descriptions = NamesManager.getNameDescriptions(this.m_toolkit, false);
            this.m_namesViewer.setInput(this.m_descriptions);
        }

        public boolean performOk() {
            try {
                NamesManager.setNameDescriptions(this.m_toolkit, this.m_descriptions);
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.VariablesPreferencePage_setErrorTitle, (String)Messages.VariablesPreferencePage_setErrorMessage);
                return false;
            }
            return super.performOk();
        }

        public void performDefaults() {
            this.m_descriptions = NamesManager.getNameDescriptions(this.m_toolkit, true);
            this.m_namesViewer.setInput(this.m_descriptions);
            super.performDefaults();
        }

        private class NamesCellModifier
        implements ICellModifier {
            private NamesCellModifier() {
            }

            public Object getValue(Object element, String property) {
                NamesManager.ComponentNameDescription description = (NamesManager.ComponentNameDescription)element;
                if ("name".equals(property)) {
                    return description.getName();
                }
                if ("acronym".equals(property)) {
                    return description.getAcronym();
                }
                if ("asField".equals(property)) {
                    return description.isAsField() ? Boolean.TRUE : Boolean.FALSE;
                }
                return null;
            }

            public boolean canModify(Object element, String property) {
                return "name".equals(property) || "acronym".equals(property) || "asField".equals(property);
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                NamesManager.ComponentNameDescription description = (NamesManager.ComponentNameDescription)element;
                try {
                    if ("name".equals(property)) {
                        description.setName((String)value);
                    }
                    if ("acronym".equals(property)) {
                        description.setAcronym((String)value);
                    }
                    if ("asField".equals(property)) {
                        description.setAsField((Boolean)value);
                    }
                    ContentsComposite.this.m_namesViewer.refresh((Object)description);
                }
                catch (Throwable e) {
                    DesignerPlugin.log(e);
                }
            }
        }

        private static class NamesLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private NamesLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                NamesManager.ComponentNameDescription description = (NamesManager.ComponentNameDescription)element;
                if (columnIndex == 3) {
                    return description.isAsField() ? IMAGE_TRUE : IMAGE_FALSE;
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                NamesManager.ComponentNameDescription description = (NamesManager.ComponentNameDescription)element;
                if (columnIndex == 0) {
                    return description.getClassName();
                }
                if (columnIndex == 1) {
                    return description.getName();
                }
                if (columnIndex == 2) {
                    return description.getAcronym();
                }
                return null;
            }
        }
    }
}

