/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.util.ObjectsLabelProvider;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldReuseVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalReuseVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.dialogfields.AbstractValidationTitleAreaDialog;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RenameConvertSupport {
    private final Iterable<? extends JavaInfo> m_components;
    private final Map<JavaInfo, RenameCommand> m_commands = Maps.newLinkedHashMap();

    public static void contribute(List<? extends ObjectInfo> objects, IContributionManager manager) {
        if (objects == null) {
            return;
        }
        Iterable components = Iterables.filter(objects, JavaInfo.class);
        RenameConvertSupport support = new RenameConvertSupport(components);
        if (components.iterator().hasNext()) {
            RenameAction action = support.new RenameAction();
            manager.appendToGroup("org.eclipse.wb.popup.group.inheritance", (IAction)action);
        }
    }

    public static void rename(List<? extends ObjectInfo> objects) {
        Iterable components = Iterables.filter(objects, JavaInfo.class);
        RenameConvertSupport support = new RenameConvertSupport(components);
        support.doRename();
    }

    private RenameConvertSupport(Iterable<? extends JavaInfo> components) {
        this.m_components = components;
    }

    private void doRename() {
        RenameDialog dialog = new RenameDialog();
        if (dialog.open() == 0) {
            this.executeCommands();
        }
    }

    private void executeCommands() {
        if (!this.m_commands.isEmpty()) {
            JavaInfo anyComponent = this.m_components.iterator().next();
            ExecutionUtils.run(anyComponent, new RunnableEx(){

                public void run() throws Exception {
                    for (RenameCommand command : RenameConvertSupport.this.m_commands.values()) {
                        command.execute();
                    }
                }
            });
        }
    }

    private String validateCommands() {
        for (RenameCommand command : this.m_commands.values()) {
            IStatus status;
            String name = command.m_name;
            if (name == null || !(status = JavaConventions.validateIdentifier((String)name)).matches(4)) continue;
            return status.getMessage();
        }
        return null;
    }

    private RenameCommand getCommand(JavaInfo javaInfo) {
        RenameCommand command = this.m_commands.get(javaInfo);
        if (command == null) {
            command = new RenameCommand(javaInfo);
            this.m_commands.put(javaInfo, command);
        }
        return command;
    }

    private class RenameAction
    extends Action {
        public RenameAction() {
            this.setImageDescriptor(DesignerPlugin.getImageDescriptor("actions/rename/rename_convert.png"));
            this.setText(ModelMessages.RenameConvertSupport_text);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof RenameAction;
        }

        public void run() {
            RenameConvertSupport.this.doRename();
        }
    }

    private static final class RenameCommand {
        private final JavaInfo m_javaInfo;
        private String m_name;
        private boolean m_toLocal;
        private boolean m_toField;

        public RenameCommand(JavaInfo javaInfo) {
            this.m_javaInfo = javaInfo;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void toLocal() {
            this.m_toLocal = true;
            this.m_toField = false;
        }

        public void toField() {
            this.m_toLocal = false;
            this.m_toField = true;
        }

        public void execute() throws Exception {
            VariableSupport variable = this.m_javaInfo.getVariableSupport();
            if (this.m_toLocal && variable.canConvertFieldToLocal()) {
                variable.convertFieldToLocal();
            } else if (this.m_toField && variable.canConvertLocalToField()) {
                variable.convertLocalToField();
            }
            variable = this.m_javaInfo.getVariableSupport();
            if (this.m_name != null && !variable.getName().equals(this.m_name)) {
                ((AbstractNamedVariableSupport)variable).setNameBase(this.m_name);
            }
        }
    }

    private class RenameDialog
    extends AbstractValidationTitleAreaDialog {
        public RenameDialog() {
            super(DesignerPlugin.getShell(), DesignerPlugin.getDefault(), ModelMessages.RenameConvertSupport_shellTitle, ModelMessages.RenameConvertSupport_title, DesignerPlugin.getImage("actions/rename/rename_banner.gif"), ModelMessages.RenameConvertSupport_message);
            this.setShellStyle(67680);
        }

        protected void createControls(Composite container) {
            GridLayoutFactory.create(container).columns(4);
            for (JavaInfo javaInfo : RenameConvertSupport.this.m_components) {
                VariableSupport variableSupport = javaInfo.getVariableSupport();
                if (!variableSupport.hasName()) continue;
                this.createControls(container, javaInfo, variableSupport);
            }
            Control[] controlArray = container.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Text) {
                    control.setFocus();
                    break;
                }
                ++n2;
            }
        }

        private void createControls(Composite container, final JavaInfo javaInfo, VariableSupport variableSupport) {
            Label iconLabel = new Label(container, 0);
            Image icon = ObjectsLabelProvider.INSTANCE.getImage(javaInfo);
            iconLabel.setImage(icon);
            Label textLabel = new Label(container, 0);
            String text = ObjectsLabelProvider.INSTANCE.getText(javaInfo);
            textLabel.setText(text);
            final Text nameText = new Text(container, 2048);
            GridDataFactory.create((Control)nameText).hintHC(30).grabH().fillH();
            nameText.setText(variableSupport.getName());
            nameText.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    RenameConvertSupport.this.getCommand(javaInfo).setName(nameText.getText());
                    RenameDialog.this.validateAll();
                }
            });
            ToolBar toolBar = new ToolBar(container, 0x800000);
            boolean isNormalVariable = variableSupport instanceof LocalUniqueVariableSupport || variableSupport instanceof LocalReuseVariableSupport || variableSupport instanceof FieldUniqueVariableSupport || variableSupport instanceof FieldReuseVariableSupport;
            ToolItem toolItem = new ToolItem(toolBar, 16);
            toolItem.setImage(DesignerPlugin.getImage("actions/rename/be_local.png"));
            toolItem.setToolTipText(ModelMessages.RenameConvertSupport_toLocal);
            toolItem.setEnabled(isNormalVariable);
            toolItem.setSelection(variableSupport instanceof LocalVariableSupport);
            toolItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    RenameConvertSupport.this.getCommand(javaInfo).toLocal();
                }
            });
            toolItem = new ToolItem(toolBar, 16);
            toolItem.setImage(DesignerPlugin.getImage("actions/rename/be_field.png"));
            toolItem.setToolTipText(ModelMessages.RenameConvertSupport_beField);
            toolItem.setEnabled(isNormalVariable);
            toolItem.setSelection(variableSupport instanceof FieldVariableSupport);
            toolItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    RenameConvertSupport.this.getCommand(javaInfo).toField();
                }
            });
        }

        protected String validate() {
            return RenameConvertSupport.this.validateCommands();
        }
    }
}

