/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.EmptyProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDisplayPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.complex.IComplexPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStyleProperty;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.impl.BooleanStylePropertyImpl;

public abstract class AbstractStylePropertyEditor
extends TextDisplayPropertyEditor
implements IComplexPropertyEditor {
    protected final List<SubStylePropertyImpl> m_macroProperties = Lists.newArrayList();
    protected final List<SubStylePropertyImpl> m_otherProperties = Lists.newArrayList();
    protected final List<SubStylePropertyImpl> m_properties = Lists.newArrayList();

    protected long getStyleValue(Property property) throws Exception {
        Object propertyValue = property.getValue();
        if (Property.UNKNOWN_VALUE == propertyValue) {
            return 0L;
        }
        Number value = (Number)propertyValue;
        return value != null ? value.longValue() : 0L;
    }

    protected abstract void setStyleValue(Property var1, long var2) throws Exception;

    protected static Property getPropertyForValue(final Object value) {
        return new EmptyProperty(){

            public Object getValue() throws Exception {
                return value;
            }
        };
    }

    public String getAsString() {
        StringBuilder builder = new StringBuilder();
        for (SubStylePropertyImpl property : this.m_properties) {
            builder.append("\t");
            property.getAsString(builder);
            builder.append("\n");
        }
        return builder.toString();
    }

    public Property[] getProperties(Property mainProperty) throws Exception {
        ObjectInfo objectInfo = mainProperty.getAdapter(ObjectInfo.class);
        Property[] properties = (Property[])objectInfo.getArbitraryValue(this);
        if (properties == null) {
            int length = this.m_properties.size();
            properties = new Property[length];
            int i = 0;
            while (i < length) {
                properties[i] = new SubStyleProperty(mainProperty, this.m_properties.get(i));
                ++i;
            }
            objectInfo.putArbitraryValue(this, properties);
        }
        return properties;
    }

    public void contributeActions(Property mainProperty, IMenuManager manager, String implementTitle, boolean isCascade) throws Exception {
        MenuManager implementMenuManager = new MenuManager(implementTitle);
        if (isCascade) {
            for (SubStylePropertyImpl property : this.m_properties) {
                if (!(property instanceof BooleanStylePropertyImpl)) continue;
                property.contributeActions(mainProperty, (IMenuManager)implementMenuManager);
            }
            implementMenuManager.add((IContributionItem)new Separator());
            for (SubStylePropertyImpl property : this.m_properties) {
                if (property instanceof BooleanStylePropertyImpl) continue;
                MenuManager subMenu = new MenuManager(property.getTitle());
                property.contributeActions(mainProperty, (IMenuManager)subMenu);
                implementMenuManager.add((IContributionItem)subMenu);
            }
        } else {
            for (SubStylePropertyImpl property : this.m_properties) {
                property.contributeActions(mainProperty, (IMenuManager)implementMenuManager);
            }
        }
        manager.appendToGroup("org.eclipse.wb.popup.group.layout", (IContributionItem)implementMenuManager);
    }
}

