/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualAssociation;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanContainerInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.utils.check.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonVisualBeanRootProcessor
implements IRootProcessor {
    public static final IRootProcessor INSTANCE = new NonVisualBeanRootProcessor();

    private NonVisualBeanRootProcessor() {
    }

    @Override
    public void process(JavaInfo root, List<JavaInfo> components) throws Exception {
        Assert.isNull(NonVisualBeanContainerInfo.find(root));
        List nonVisualBeans = Lists.newArrayList();
        for (JavaInfo component : components) {
            if (component.getParent() != null || NonVisualBeanInfo.getNonVisualInfo(component) == null) continue;
            nonVisualBeans.add(component);
        }
        if (!nonVisualBeans.isEmpty()) {
            NonVisualBeanContainerInfo container = new NonVisualBeanContainerInfo();
            root.addChild(container);
            for (JavaInfo component : nonVisualBeans) {
                component.setAssociation(new NonVisualAssociation());
                container.addChild(component);
            }
        }
    }
}

