/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.EvaluationEventListener;
import org.eclipse.wb.internal.core.eval.evaluators.InvocationEvaluator;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupportUtils;
import org.eclipse.wb.internal.core.model.creation.MethodParameterCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.SuperConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupportUtils;
import org.eclipse.wb.internal.core.model.variable.MethodParameterVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.AstReflectionUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThisCreationSupport
extends CreationSupport {
    private final MethodDeclaration m_constructor;
    private SuperConstructorInvocation m_invocation;
    private ConstructorDescription m_description;
    private CreationSupportUtils m_utils;
    private EditorState m_editorState;
    private boolean m_interceptOnlyDuringExecution;
    private Predicate<Method> m_methodInterceptorPredicate = Predicates.alwaysTrue();
    private static final String KEY_PARAMETER_BASED_COMPONENT = "KEY_PARAMETER_BASED_COMPONENT";
    private Enhancer m_enhancer;
    private static final CallbackFilter ENHANCER_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (ReflectionUtils.isPrivate(method) || ReflectionUtils.isPackagePrivate(method)) {
                return 1;
            }
            if (method.getDeclaringClass().getClassLoader() == null) {
                return 1;
            }
            return 0;
        }
    };
    private ComplexProperty m_complexProperty;

    public ThisCreationSupport(MethodDeclaration constructor) {
        this.m_constructor = constructor;
    }

    public String toString() {
        return "this: " + this.getComponentClass().getName();
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_editorState = JavaInfoUtils.getState(javaInfo);
        this.m_interceptOnlyDuringExecution = JavaInfoUtils.hasTrueParameter(javaInfo, "interceptOnlyDuringExecution");
        this.m_methodInterceptorPredicate = ThisCreationSupport.createInterceptionPredicate_excludeByPackage(this.m_javaInfo);
        this.prepareSuperConstructorInvocation(javaInfo);
        this.m_javaInfo.addBroadcastListener(new EvaluationEventListener(){

            public void evaluateAfter(EvaluationContext context, ASTNode node) throws Exception {
                if (this.shouldTryToExposeChildren(node)) {
                    ThisCreationSupport.this.duringParsing_createExposedChildren();
                    ThisCreationSupport.this.m_javaInfo.setObject(ThisCreationSupport.this.m_javaInfo.getObject());
                }
            }

            private boolean shouldTryToExposeChildren(ASTNode node) {
                if (node instanceof ExpressionStatement) {
                    Expression expression = ((ExpressionStatement)node).getExpression();
                    return expression instanceof SuperMethodInvocation;
                }
                return false;
            }
        });
        this.m_utils = new CreationSupportUtils(this.m_javaInfo);
    }

    private void prepareSuperConstructorInvocation(JavaInfo javaInfo) {
        if (javaInfo.getDescription().getComponentClass().isInterface()) {
            return;
        }
        this.m_invocation = this.findSuperConstructorInvocation(this.m_constructor);
        if (this.m_invocation != null) {
            IMethodBinding constructorBinding = AstNodeUtils.getSuperBinding(this.m_invocation);
            this.m_description = this.m_javaInfo.getDescription().getConstructor(constructorBinding);
            ComponentDescriptionHelper.ensureInitialized(this.m_javaInfo.getEditor().getJavaProject(), this.m_description);
        }
    }

    private SuperConstructorInvocation findSuperConstructorInvocation(MethodDeclaration constructor) {
        List<Statement> statements = DomGenerics.statements(constructor);
        if (statements.isEmpty()) {
            return null;
        }
        Statement statement = statements.get(0);
        if (statement instanceof ConstructorInvocation) {
            ConstructorInvocation invocation = (ConstructorInvocation)statement;
            constructor = AstNodeUtils.getConstructor(invocation);
            Assert.isNotNull(constructor, "Can not find constructor declaration for %s", invocation);
            return this.findSuperConstructorInvocation(constructor);
        }
        if (statement instanceof SuperConstructorInvocation) {
            return (SuperConstructorInvocation)statement;
        }
        return null;
    }

    @Override
    public boolean isJavaInfo(ASTNode node) {
        return node == null || node instanceof ThisExpression || node == this.m_constructor;
    }

    @Override
    public ASTNode getNode() {
        return this.m_constructor;
    }

    @Override
    public boolean canBeEvaluated() {
        return false;
    }

    public MethodDeclaration getConstructor() {
        return this.m_constructor;
    }

    public SuperConstructorInvocation getInvocation() {
        return this.m_invocation;
    }

    @Override
    public Object create(EvaluationContext context, ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) throws Exception {
        Object[] argumentValues;
        Constructor<?> constructor;
        String signature;
        Class<?> componentClass = this.getComponentClass();
        if (this.m_invocation != null) {
            IMethodBinding methodBinding = AstNodeUtils.getSuperBinding(this.m_invocation);
            signature = AstNodeUtils.getMethodSignature(methodBinding);
            constructor = AstReflectionUtils.getConstructor(componentClass, this.m_invocation);
            List<Expression> arguments = DomGenerics.arguments(this.m_invocation);
            argumentValues = ThisCreationSupport.evaluateExpressions(context, arguments);
            argumentValues = AstReflectionUtils.updateForVarArgs(context.getClassLoader(), methodBinding, argumentValues);
        } else {
            signature = "<init>()";
            constructor = ReflectionUtils.getConstructorBySignature(componentClass, "<init>()");
            argumentValues = ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (constructor == null && !componentClass.isInterface()) {
            throw new DesignerException(314, signature, componentClass.getName());
        }
        try {
            Object object = this.create0(visitor, constructor, componentClass, argumentValues);
            this.m_javaInfo.setObject(object);
            this.duringParsing_createExposedChildren();
            return object;
        }
        catch (DesignerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new DesignerException(313, e, ReflectionUtils.getShortConstructorString(constructor), InvocationEvaluator.getArguments_toString(argumentValues), AstEvaluationEngine.getUserStackTrace(e));
        }
    }

    private Object create0(ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor, Constructor<?> constructor, Class<?> componentClass, Object[] argumentValues) throws Exception {
        if (this.needEnhancer() && this.hasCGLib()) {
            return this.create_usingCGLib(visitor, constructor, componentClass, argumentValues);
        }
        return constructor.newInstance(argumentValues);
    }

    private Object create_usingCGLib(ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor, Constructor<?> constructor, Class<?> componentClass, Object[] argumentValues) {
        this.createEnhancer(componentClass, visitor);
        ExecutionFlowDescription flowDescription = this.m_editorState.getFlowDescription();
        flowDescription.enterStatement((Statement)this.m_constructor.getBody());
        try {
            if (constructor != null) {
                Assert.isTrueException(!ReflectionUtils.isPackagePrivate(constructor), 311, constructor);
                Object object = this.m_enhancer.create((Class[])constructor.getParameterTypes(), argumentValues);
                return object;
            }
            Object object = this.m_enhancer.create();
            return object;
        }
        finally {
            flowDescription.leaveStatement((Statement)this.m_constructor.getBody());
        }
    }

    private boolean needEnhancer() {
        boolean isSystemClass;
        ComponentDescription description = this.m_javaInfo.getDescription();
        if (description.hasTrueParameter("binaryExecutionFlow.no")) {
            return false;
        }
        Class<?> componentClass = description.getComponentClass();
        boolean bl = isSystemClass = componentClass.getClassLoader() == null;
        return !isSystemClass && !Enhancer.isEnhanced(componentClass);
    }

    private boolean hasCGLib() {
        try {
            ClassLoader classLoader = this.getClassLoader();
            return classLoader != null && classLoader.loadClass("net.sf.cglib.proxy.Factory") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private ClassLoader getClassLoader() {
        return JavaInfoUtils.getClassLoader(this.m_javaInfo);
    }

    private void createEnhancer(Class<?> componentClass, final ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) {
        this.m_enhancer = new Enhancer();
        this.m_enhancer.setClassLoader(this.getClassLoader());
        this.m_enhancer.setSuperclass(componentClass);
        MethodInterceptor interceptor = new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (ThisCreationSupport.this.m_interceptOnlyDuringExecution && !ThisCreationSupport.this.m_editorState.isExecuting()) {
                    if (ReflectionUtils.isAbstract(method)) {
                        return this.returnDefaultValue(method);
                    }
                    return proxy.invokeSuper(obj, args);
                }
                if (!method.isBridge() && !ThisCreationSupport.this.isSuperMethodInvocation()) {
                    String methodSignature = ReflectionUtils.getMethodSignature(method);
                    if (methodSignature.equals("isValidSubclass()")) {
                        return Boolean.TRUE;
                    }
                    if (methodSignature.equals("checkSubclass()")) {
                        return null;
                    }
                    Object result = ThisCreationSupport.this.tryModelMethodInterceptor(method, methodSignature, args);
                    if (result != AstEvaluationEngine.UNKNOWN) {
                        return result;
                    }
                    if (!ThisCreationSupport.this.canInterceptMethod(method, methodSignature)) {
                        return proxy.invokeSuper(obj, args);
                    }
                    TypeDeclaration typeDeclaration = (TypeDeclaration)ThisCreationSupport.this.m_constructor.getParent();
                    MethodDeclaration methodDeclaration = AstNodeUtils.getMethodBySignature(typeDeclaration, methodSignature);
                    if (methodDeclaration != null && !AstNodeUtils.isAbstract(methodDeclaration)) {
                        JavaInfoEvaluationHelper.shouldEvaluateReturnValue(methodDeclaration, true);
                        return ThisCreationSupport.this.visitMethod(obj, method, args, proxy, methodDeclaration, visitor);
                    }
                }
                if (ReflectionUtils.isAbstract(method)) {
                    return this.returnDefaultValue(method);
                }
                return proxy.invokeSuper(obj, args);
            }

            private Object returnDefaultValue(Method method) {
                Class<?> returnType = method.getReturnType();
                return ReflectionUtils.getDefaultValue(returnType);
            }
        };
        this.m_enhancer.setCallbacks(new Callback[]{interceptor, NoOp.INSTANCE});
        this.m_enhancer.setCallbackFilter(ENHANCER_FILTER);
    }

    private static Predicate<Method> createInterceptionPredicate_excludeByPackage(JavaInfo javaInfo) {
        final Map excludedPackages = Maps.newHashMap();
        String parameterNamePrefix = "binaryExecutionFlow.dontVisit.package ";
        for (Map.Entry<String, String> entry : JavaInfoUtils.getParameters(javaInfo).entrySet()) {
            String parameterName = entry.getKey();
            if (!parameterName.startsWith(parameterNamePrefix)) continue;
            String packageName = parameterName.substring(parameterNamePrefix.length()).trim();
            class ExcludedPackage {
                Set<String> exceptions = Sets.newHashSet();

                ExcludedPackage() {
                }
            }
            ExcludedPackage excludedPackage = new ExcludedPackage();
            String exceptionMethodsString = entry.getValue();
            Object[] exceptionMethodsSignatures = StringUtils.split((String)exceptionMethodsString);
            excludedPackage.exceptions = (Set)ImmutableSet.copyOf((Object[])exceptionMethodsSignatures);
            excludedPackages.put(packageName, excludedPackage);
        }
        return new Predicate<Method>(){

            public boolean apply(Method method) {
                String declaringClassName = method.getDeclaringClass().getName();
                String declaringPackage = CodeUtils.getPackage(declaringClassName);
                ExcludedPackage excludedPackage = (ExcludedPackage)excludedPackages.get(declaringPackage);
                if (excludedPackage != null) {
                    String signature = ReflectionUtils.getMethodSignature(method);
                    return excludedPackage.exceptions.contains(signature);
                }
                return true;
            }
        };
    }

    private boolean isSuperMethodInvocation() {
        ASTNode root = this.m_constructor.getRoot();
        try {
            boolean bl = root.getProperty("SUPER_MI_KEY") == Boolean.TRUE;
            return bl;
        }
        finally {
            root.setProperty("SUPER_MI_KEY", null);
        }
    }

    private Object tryModelMethodInterceptor(Method method, String signature, Object[] args) throws Exception {
        String interceptorName = "this.interceptMethod: " + signature;
        String script = JavaInfoUtils.getParameter(this.m_javaInfo, interceptorName);
        if (script != null) {
            return ScriptUtils.evaluate(this.getClassLoader(), script, "model", this.m_javaInfo);
        }
        interceptorName = String.valueOf(method.getName()) + "_interceptor";
        Method interceptor = ReflectionUtils.getMethod(this.m_javaInfo.getClass(), interceptorName, method.getParameterTypes());
        if (interceptor != null) {
            return interceptor.invoke((Object)this.m_javaInfo, args);
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private boolean canInterceptMethod(Method method, String signature) throws Exception {
        MethodDescription methodDescription = this.m_javaInfo.getDescription().getMethod(signature);
        if (methodDescription != null && methodDescription.hasTrueTag("binaryExecutionFlow.dontVisit")) {
            return false;
        }
        return this.m_methodInterceptorPredicate.apply((Object)method);
    }

    private Object visitMethod(Object obj, Method method, Object[] args, MethodProxy proxy, MethodDeclaration methodDeclaration, ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) throws Exception {
        Object result = this.visitMethod0(obj, method, args, proxy, methodDeclaration, visitor);
        result = this.visitMethod_validator(method, args, result);
        return result;
    }

    private Object visitMethod_validator(Method method, Object[] args, Object result) throws Exception {
        Class[] validatorParameterTypes = (Class[])ArrayUtils.add((Object[])method.getParameterTypes(), Object.class);
        String validatorName = String.valueOf(method.getName()) + "_validator";
        Method validator = ReflectionUtils.getMethod(this.m_javaInfo.getClass(), validatorName, validatorParameterTypes);
        if (validator != null) {
            Object[] validatorArgs = ArrayUtils.add((Object[])args, (Object)result);
            result = validator.invoke((Object)this.m_javaInfo, validatorArgs);
        }
        return result;
    }

    private Object visitMethod0(Object obj, Method method, Object[] args, MethodProxy proxy, MethodDeclaration methodDeclaration, ExecutionFlowUtils.ExecutionFlowFrameVisitor visitor) throws Exception {
        boolean lazyMethod;
        this.m_javaInfo.setObject(obj);
        this.duringParsing_createExposedChildren();
        AstEditor editor = this.m_javaInfo.getEditor();
        ExecutionFlowDescription flowDescription = this.m_editorState.getFlowDescription();
        boolean simpleReturnMethod = ThisCreationSupport.isSimpleReturnMethod((ASTNode)methodDeclaration);
        boolean bl = lazyMethod = LazyVariableSupportUtils.getInformation(methodDeclaration) != null;
        if (!simpleReturnMethod && !lazyMethod) {
            Set<MethodDeclaration> interceptedMethods = this.m_editorState.getTmp_InterceptedMethods();
            if (interceptedMethods.contains(methodDeclaration)) {
                return ReflectionUtils.getDefaultValue(method.getReturnType());
            }
            interceptedMethods.add(methodDeclaration);
        }
        this.processMethodParameterComponents(editor, flowDescription, method, args, methodDeclaration);
        if (!flowDescription.isBinaryFlowLocked()) {
            flowDescription.addBinaryFlowMethodAfter(methodDeclaration);
        }
        ExecutionFlowUtils.visit(this.m_editorState.getTmp_visitingContext(), flowDescription, visitor, (List)ImmutableList.of((Object)methodDeclaration));
        return JavaInfoEvaluationHelper.getReturnValue(methodDeclaration);
    }

    private static boolean isSimpleReturnMethod(ASTNode node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            List<Statement> statements = DomGenerics.statements(methodDeclaration);
            return methodDeclaration.parameters().isEmpty() && statements.size() == 1 && ThisCreationSupport.isSimpleReturnMethod((ASTNode)statements.get(0));
        }
        if (node instanceof ReturnStatement) {
            ReturnStatement returnStatement = (ReturnStatement)node;
            return ThisCreationSupport.isSimpleReturnMethod((ASTNode)returnStatement.getExpression());
        }
        if (node instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)node;
            return ThisCreationSupport.isSimpleReturnMethod((ASTNode)parenthesizedExpression.getExpression());
        }
        return node instanceof SimpleName;
    }

    private void processMethodParameterComponents(AstEditor editor, ExecutionFlowDescription flowDescription, Method method, Object[] args, MethodDeclaration methodDeclaration) throws Exception {
        block10: {
            SingleVariableDeclaration parameter;
            int i;
            List<SingleVariableDeclaration> parameters;
            block8: {
                Class<?>[] parameterTypes = method.getParameterTypes();
                parameters = DomGenerics.parameters(methodDeclaration);
                i = 0;
                while (i < args.length) {
                    parameter = parameters.get(i);
                    parameter.setProperty("KEY_PARAMETER_HAS_VALUE", (Object)Boolean.TRUE);
                    parameter.setProperty("KEY_PARAMETER_VALUE", args[i]);
                    ++i;
                }
                if (flowDescription.isBinaryFlowLocked()) break block8;
                i = 0;
                while (i < args.length) {
                    block9: {
                        if (!parameterTypes[i].isPrimitive() && args[i] != null) {
                            ComponentDescription componentDescription;
                            parameter = parameters.get(i);
                            try {
                                componentDescription = ComponentDescriptionHelper.getDescription(editor, this.m_javaInfo.getDescription(), parameter);
                                if ("true".equals(componentDescription.getParameter("thisCreation.ignoreBind"))) {
                                }
                            }
                            catch (Throwable throwable) {}
                            break block9;
                            JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(editor, componentDescription, (CreationSupport)new MethodParameterCreationSupport(parameter));
                            javaInfo.setVariableSupport(new MethodParameterVariableSupport(javaInfo, parameter));
                            javaInfo.setObject(args[i]);
                            parameter.setProperty(KEY_PARAMETER_BASED_COMPONENT, (Object)javaInfo);
                            this.m_editorState.getTmp_Components().add(javaInfo);
                            ExecutionFlowUtils2.ensurePermanentValue((Expression)parameter.getName()).setModel(javaInfo);
                        }
                    }
                    ++i;
                }
                break block10;
            }
            i = 0;
            while (i < parameters.size()) {
                parameter = parameters.get(i);
                JavaInfo javaInfo = (JavaInfo)parameter.getProperty(KEY_PARAMETER_BASED_COMPONENT);
                if (javaInfo != null) {
                    javaInfo.setObject(args[i]);
                }
                ++i;
            }
        }
    }

    private void duringParsing_createExposedChildren() throws Exception {
        if (GlobalState.isParsing()) {
            this.m_javaInfo.createExposedChildren();
        }
    }

    private static Object[] evaluateExpressions(EvaluationContext context, List<Expression> expressions) throws Exception {
        Object[] values = new Object[expressions.size()];
        int i = 0;
        while (i < values.length) {
            Expression expression = expressions.get(i);
            values[i] = AstEvaluationEngine.evaluate(context, expression);
            ++i;
        }
        return values;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public void delete() throws Exception {
        JavaInfoUtils.deleteJavaInfo(this.m_javaInfo, false);
    }

    @Override
    public void addProperties(List<Property> properties) throws Exception {
        if (this.m_complexProperty == null) {
            this.m_complexProperty = new ComplexProperty("Constructor", "(Constructor properties)");
            this.m_complexProperty.setCategory(PropertyCategory.system(3));
            this.m_complexProperty.setModified(true);
            List subPropertiesList = Lists.newArrayList();
            if (this.m_invocation != null) {
                for (ParameterDescription parameter : this.m_description.getParameters()) {
                    Property property = this.m_utils.createProperty(parameter);
                    if (property == null) continue;
                    subPropertiesList.add(property);
                }
                if (!subPropertiesList.isEmpty()) {
                    this.m_complexProperty.setProperties(subPropertiesList);
                }
            }
        }
        if (this.m_complexProperty.getProperties().length != 0) {
            properties.add(this.m_complexProperty);
        }
    }

    @Override
    public void addAccessors(GenericPropertyDescription propertyDescription, List<ExpressionAccessor> accessors) throws Exception {
        if (this.m_invocation != null) {
            for (ParameterDescription parameter : this.m_description.getParameters()) {
                if (!propertyDescription.getId().equals(parameter.getProperty())) continue;
                accessors.add(new SuperConstructorAccessor(this.m_invocation, parameter.getIndex(), parameter.getDefaultSource()));
            }
        }
    }
}

