/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.internal.core.gef.policy.snapping.BaselineComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.ComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.ContainerSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.ISnapPointsListener;
import org.eclipse.wb.internal.core.gef.policy.snapping.ISnapPointsProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.IndentedComponentSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementsSupport;
import org.eclipse.wb.internal.core.gef.policy.snapping.SameSizeSnapPoint;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapPoints {
    protected final IVisualDataProvider m_visualDataProvider;
    protected final List<IAbstractComponentInfo> m_allWidgets;
    protected Point m_lastMouseLocation;
    protected int m_horizontalMouseMoveDirection;
    protected int m_verticalMouseMoveDirection;
    protected List<Figure> m_feedbacks = Lists.newArrayList();
    private final IFeedbackProxy m_feedbackProxy;
    private SnapPoint m_horizontalSnappedPoint;
    private SnapPoint m_verticalSnappedPoint;
    private final ISnapPointsProvider m_snapPoints;
    private final ISnapPointsListener m_listener;

    public SnapPoints(IVisualDataProvider visualDataProvider, IFeedbackProxy feedbackProxy, ISnapPointsProvider snapPoints, ISnapPointsListener listener, List<? extends IAbstractComponentInfo> allWidgets) {
        this.m_visualDataProvider = visualDataProvider;
        this.m_feedbackProxy = feedbackProxy;
        this.m_snapPoints = snapPoints;
        this.m_listener = listener;
        this.m_allWidgets = Lists.newArrayList(allWidgets);
    }

    public SnapPoints(IVisualDataProvider visualDataProvider, IFeedbackProxy feedbackProxy, List<? extends IAbstractComponentInfo> allWidgets) {
        this(visualDataProvider, feedbackProxy, new DefaultSnapPoints(visualDataProvider, allWidgets), null, allWidgets);
    }

    public void processBounds(Point location, List<? extends IAbstractComponentInfo> beingSnappedList, Rectangle snappedBounds, int resizeDirection) {
        this.calculateMouseMoveDirections(location);
        this.removeFeedbacks();
        this.m_horizontalSnappedPoint = null;
        this.m_verticalSnappedPoint = null;
        if (!this.m_visualDataProvider.isSuppressingSnapping()) {
            if (this.m_visualDataProvider.useFreeSnapping()) {
                for (SnapPoint snapPoint : this.getSnapPoints(false)) {
                    if (!snapPoint.snap(beingSnappedList, snappedBounds, this.m_verticalMouseMoveDirection, resizeDirection)) continue;
                    this.m_verticalSnappedPoint = snapPoint;
                    break;
                }
                for (SnapPoint snapPoint : this.getSnapPoints(true)) {
                    if (!snapPoint.snap(beingSnappedList, snappedBounds, this.m_horizontalMouseMoveDirection, resizeDirection)) continue;
                    this.m_horizontalSnappedPoint = snapPoint;
                    break;
                }
            }
            if (this.m_verticalSnappedPoint == null && (resizeDirection == 0 || (resizeDirection & 8) != 0 || (resizeDirection & 0x10) != 0)) {
                this.applyGrid(snappedBounds, resizeDirection, true);
            }
            if (this.m_horizontalSnappedPoint == null && (resizeDirection == 0 || (resizeDirection & 1) != 0 || (resizeDirection & 4) != 0)) {
                this.applyGrid(snappedBounds, resizeDirection, false);
            }
            if (this.m_verticalSnappedPoint != null) {
                this.m_verticalSnappedPoint.addFeedback(snappedBounds, this.m_feedbackProxy, this.m_feedbacks);
            }
            if (this.m_horizontalSnappedPoint != null) {
                this.m_horizontalSnappedPoint.addFeedback(snappedBounds, this.m_feedbackProxy, this.m_feedbacks);
            }
        }
        if (this.m_listener != null) {
            this.m_listener.boundsChanged(snappedBounds, beingSnappedList, new SnapPoint[]{this.m_horizontalSnappedPoint, this.m_verticalSnappedPoint}, new int[]{this.m_horizontalMouseMoveDirection, this.m_verticalMouseMoveDirection});
        }
    }

    void processBounds(PlacementsSupport placements, Point location, List<? extends IAbstractComponentInfo> beingSnappedList, int resizeDirection) {
        Rectangle snappedBounds = placements.getInternalBounds();
        this.processBounds(location, beingSnappedList, snappedBounds, resizeDirection);
        placements.doDrag(new int[]{this.m_horizontalMouseMoveDirection, this.m_verticalMouseMoveDirection}, new SnapPoint[]{this.m_horizontalSnappedPoint, this.m_verticalSnappedPoint});
    }

    private void applyGrid(Rectangle snappedBounds, int resizeDirection, boolean isHorizontal) {
        if (!this.m_visualDataProvider.useGridSnapping()) {
            return;
        }
        Transposer t = new Transposer(!isHorizontal);
        Rectangle transposed = t.t(snappedBounds);
        this.applyGrid(transposed, resizeDirection, isHorizontal ? this.m_horizontalMouseMoveDirection : this.m_verticalMouseMoveDirection, isHorizontal ? this.m_visualDataProvider.getGridStepX() : this.m_visualDataProvider.getGridStepY());
        snappedBounds.setBounds(t.t(transposed));
    }

    private void applyGrid(Rectangle bounds, int resizeDirection, int moveDirection, int gridStep) {
        if (resizeDirection == 0) {
            if (moveDirection == 0) {
                int snapX;
                bounds.x = snapX = this.applyGrid(bounds.x, gridStep);
            } else {
                int snapRight = this.applyGrid(bounds.right(), gridStep);
                bounds.x = snapRight - bounds.width;
            }
        } else if ((resizeDirection & 8) != 0 || (resizeDirection & 1) != 0) {
            int snapX = this.applyGrid(bounds.x, gridStep);
            bounds.width = bounds.right() - snapX;
            bounds.x = snapX;
        } else if ((resizeDirection & 0x10) != 0 || (resizeDirection & 4) != 0) {
            int snapRight = this.applyGrid(bounds.right(), gridStep);
            bounds.width = snapRight - bounds.x;
        }
    }

    private int applyGrid(int value, int step) {
        return value / step * step;
    }

    protected void calculateMouseMoveDirections(Point mouseLocation) {
        if (this.m_lastMouseLocation == null) {
            this.m_lastMouseLocation = mouseLocation;
            return;
        }
        int deltaX = mouseLocation.x - this.m_lastMouseLocation.x;
        int deltaY = mouseLocation.y - this.m_lastMouseLocation.y;
        if (deltaX != 0) {
            int n = this.m_horizontalMouseMoveDirection = deltaX > 0 ? 1 : 0;
        }
        if (deltaY != 0) {
            this.m_verticalMouseMoveDirection = deltaY > 0 ? 1 : 0;
        }
        this.m_lastMouseLocation = mouseLocation;
    }

    private List<SnapPoint> getSnapPoints(boolean isHorizontal) {
        List pts = Lists.newArrayList();
        for (IAbstractComponentInfo child : this.m_allWidgets) {
            pts.addAll(this.m_snapPoints.forComponent(child, isHorizontal));
        }
        pts.addAll(this.m_snapPoints.forContainer(isHorizontal));
        return pts;
    }

    public void removeFeedbacks() {
        for (Figure figure : this.m_feedbacks) {
            FigureUtils.removeFigure(figure);
        }
        this.m_feedbacks = Lists.newArrayList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultSnapPoints
    implements ISnapPointsProvider {
        private final IVisualDataProvider m_visualDataProvider;
        private final List<? extends IAbstractComponentInfo> m_allWidgets;

        public DefaultSnapPoints(IVisualDataProvider visualDataProvider, List<? extends IAbstractComponentInfo> allWidgets) {
            this.m_visualDataProvider = visualDataProvider;
            this.m_allWidgets = allWidgets;
        }

        @Override
        public List<SnapPoint> forContainer(boolean isHorizontal) {
            List pts = Lists.newArrayList();
            int leadingSide = PlacementUtils.getSide(isHorizontal, true);
            int trailingSide = PlacementUtils.getSide(isHorizontal, false);
            pts.add(new ContainerSnapPoint(this.m_visualDataProvider, leadingSide, true));
            pts.add(new ContainerSnapPoint(this.m_visualDataProvider, leadingSide));
            pts.add(new ContainerSnapPoint(this.m_visualDataProvider, trailingSide, true));
            pts.add(new ContainerSnapPoint(this.m_visualDataProvider, trailingSide));
            pts.add(new SameSizeSnapPoint(this.m_visualDataProvider, this.m_allWidgets, leadingSide));
            pts.add(new SameSizeSnapPoint(this.m_visualDataProvider, this.m_allWidgets, trailingSide));
            return pts;
        }

        @Override
        public List<SnapPoint> forComponent(IAbstractComponentInfo target, boolean isHorizontal) {
            List pts = Lists.newArrayList();
            int leadingSide = PlacementUtils.getSide(isHorizontal, true);
            int trailingSide = PlacementUtils.getSide(isHorizontal, false);
            if (isHorizontal) {
                pts.add(new IndentedComponentSnapPoint(this.m_visualDataProvider, target));
            } else {
                pts.add(new BaselineComponentSnapPoint(this.m_visualDataProvider, target));
            }
            pts.add(new ComponentSnapPoint(this.m_visualDataProvider, target, leadingSide, 1, true));
            pts.add(new ComponentSnapPoint(this.m_visualDataProvider, target, leadingSide, 0));
            pts.add(new ComponentSnapPoint(this.m_visualDataProvider, target, trailingSide, 0, true));
            pts.add(new ComponentSnapPoint(this.m_visualDataProvider, target, trailingSide, 1));
            return pts;
        }
    }
}

