/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import java.util.List;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.internal.core.gef.policy.snapping.IFeedbackProxy;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.gef.policy.snapping.SnapPointCommand;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SnapPoint {
    public static final int SNAP_DISTANCE = 10;
    private Interval m_xSnapInterval;
    private Interval m_ySnapInterval;
    private final int m_snapDirection;
    protected int m_snapDistance = 10;
    protected int m_snapPoint;
    protected Interval m_snapInterval;
    protected final int m_side;
    protected IAbstractComponentInfo m_nearestBeingSnapped;
    protected IVisualDataProvider m_visualDataProvider;
    protected boolean m_isResizing;
    private SnapPointCommand m_command;
    private List<? extends IAbstractComponentInfo> m_workingSet;

    public SnapPoint(IVisualDataProvider visualDataProvider, int side, int snapDirection) {
        this.m_visualDataProvider = visualDataProvider;
        this.m_snapDirection = snapDirection;
        this.m_side = side;
    }

    public boolean snap(List<? extends IAbstractComponentInfo> beingSnappedList, Rectangle beingSnappedBounds, int moveDirection, int resizeDirection) {
        int beingSnappedPoint;
        boolean bl = this.m_isResizing = resizeDirection != 0;
        if (!this.snapAllowed(beingSnappedList)) {
            return false;
        }
        this.updateSnapData(beingSnappedList);
        if (this.checkDirection() && !this.validDirection(moveDirection)) {
            return false;
        }
        Interval xSnapInterval = new Interval(beingSnappedBounds.x, beingSnappedBounds.width);
        Interval ySnapInterval = new Interval(beingSnappedBounds.y, beingSnappedBounds.height);
        if (!this.m_xSnapInterval.intersects(xSnapInterval) || !this.m_ySnapInterval.intersects(ySnapInterval)) {
            return false;
        }
        Transposer t = new Transposer();
        t.setEnabled(!this.isHorizontal());
        Rectangle transposedBounds = t.t(beingSnappedBounds);
        int n = beingSnappedPoint = this.m_snapDirection == 0 ? transposedBounds.x : transposedBounds.right();
        if (this.m_isResizing) {
            if (this.isValidResizeDirection(resizeDirection) && this.m_snapInterval.contains(beingSnappedPoint)) {
                if (this.m_snapDirection == 0) {
                    transposedBounds.width += transposedBounds.x - this.m_snapPoint;
                    transposedBounds.x = this.m_snapPoint;
                } else {
                    transposedBounds.width = this.m_snapPoint - transposedBounds.x;
                }
                beingSnappedBounds.setBounds(t.t(transposedBounds));
                return true;
            }
        } else if (this.m_snapInterval.contains(beingSnappedPoint)) {
            transposedBounds.x = this.m_snapDirection == 0 ? this.m_snapPoint : this.m_snapPoint - transposedBounds.width;
            beingSnappedBounds.setBounds(t.t(transposedBounds));
            return true;
        }
        return false;
    }

    protected boolean isValidResizeDirection(int resizeDirection) {
        if (this.isHorizontal()) {
            return this.m_snapDirection == 0 && (resizeDirection & 8) != 0 || this.m_snapDirection == 1 && (resizeDirection & 0x10) != 0;
        }
        return this.m_snapDirection == 0 && (resizeDirection & 1) != 0 || this.m_snapDirection == 1 && (resizeDirection & 4) != 0;
    }

    public void addFeedback(Rectangle snappedBounds, IFeedbackProxy feedbackProxy, List<Figure> feedbacks) {
    }

    protected boolean checkDirection() {
        return true;
    }

    protected boolean validDirection(int direction) {
        return this.m_snapDirection == direction;
    }

    protected boolean snapAllowed(List<? extends IAbstractComponentInfo> beingSnappedList) {
        return true;
    }

    protected boolean isHorizontal() {
        return this.m_side == 1 || this.m_side == 4;
    }

    private void updateSnapData(List<? extends IAbstractComponentInfo> beingSnappedList) {
        this.m_workingSet = beingSnappedList;
        this.calculateSnapPoint(beingSnappedList);
        this.m_xSnapInterval = this.getXSnapInterval();
        this.m_ySnapInterval = this.getYSnapInterval();
        this.m_snapInterval = new Interval(this.m_snapPoint - this.m_snapDistance, this.m_snapDistance * 2);
    }

    protected void calculateSnapPoint(List<? extends IAbstractComponentInfo> beingSnappedList) {
        this.m_nearestBeingSnapped = this.getNearestComponentToSide(beingSnappedList);
    }

    protected Interval getXSnapInterval() {
        return Interval.INFINITE;
    }

    protected Interval getYSnapInterval() {
        return Interval.INFINITE;
    }

    protected IAbstractComponentInfo getNearestComponentToSide(List<? extends IAbstractComponentInfo> beingSnappedList) {
        return SnapPoint.getNearestComponentToSide(beingSnappedList, this.m_side, this.isHorizontal(), this.m_visualDataProvider);
    }

    public static IAbstractComponentInfo getNearestComponentToSide(List<? extends IAbstractComponentInfo> beingSnappedList, int side, boolean isHorizontal, IVisualDataProvider provider) {
        if (beingSnappedList.size() == 1) {
            return beingSnappedList.get(0);
        }
        boolean isLeading = PlacementUtils.isLeadingSide(side);
        Transposer t = new Transposer();
        t.setEnabled(!isHorizontal);
        int offset = isLeading ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        IAbstractComponentInfo result = null;
        for (IAbstractComponentInfo iAbstractComponentInfo : beingSnappedList) {
            Rectangle bounds = t.t(PlacementUtils.getTranslatedBounds(provider, iAbstractComponentInfo));
            int newOffset = isLeading ? Math.min(offset, bounds.x) : Math.max(offset, bounds.right());
            if (newOffset != (isLeading ? bounds.x : bounds.right())) continue;
            result = iAbstractComponentInfo;
            offset = newOffset;
        }
        return result;
    }

    public String toString() {
        String name = CodeUtils.getShortClass(this.getClass().getName());
        return String.valueOf(name) + "(side=" + SnapPoint.sideToString(this.m_side) + " snapDir=" + (this.m_snapDirection == 0 ? "LEADING" : "TRAILING") + this.getObjectInfo() + ")";
    }

    private static String sideToString(int side) {
        switch (side) {
            case 8: {
                return "TOP";
            }
            case 32: {
                return "BOTTOM";
            }
            case 1: {
                return "LEFT";
            }
            case 4: {
                return "RIGHT";
            }
        }
        return Integer.toString(side);
    }

    protected String getObjectInfo() {
        return "";
    }

    public final int getValue() {
        return this.m_snapPoint;
    }

    public final List<? extends IAbstractComponentInfo> getWorkingSet() {
        return this.m_workingSet;
    }

    public final IAbstractComponentInfo getNearestBeingSnapped() {
        return this.m_nearestBeingSnapped;
    }

    public final int getSide() {
        return this.m_side;
    }

    public final int getSnapDirection() {
        return this.m_snapDirection;
    }

    public final Command getCommand() {
        return this.m_command;
    }

    public final void setCommand(SnapPointCommand command) {
        this.m_command = command;
    }
}

