/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.generic;

import org.eclipse.wb.core.gef.policy.layout.flow.ObjectFlowLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.selection.NonResizableSelectionEditPolicy;
import org.eclipse.wb.core.gef.policy.validator.LayoutRequestValidators;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.internal.core.gef.policy.layout.generic.AbstractContainerRequestValidator;
import org.eclipse.wb.internal.core.gef.policy.layout.generic.SelectionEditPolicyInstaller;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FlowContainerLayoutEditPolicy
extends ObjectFlowLayoutEditPolicy<Object> {
    private final FlowContainer m_container;
    private final ILayoutRequestValidator m_requestValidator;
    private final ObjectInfo m_model;

    public FlowContainerLayoutEditPolicy(ObjectInfo model, FlowContainer container) {
        super(model);
        this.m_model = model;
        this.m_container = container;
        ILayoutRequestValidator validator = new AbstractContainerRequestValidator(container);
        validator = LayoutRequestValidators.cache(validator);
        this.m_requestValidator = LayoutRequestValidators.finalize(validator);
    }

    @Override
    protected void decorateChild(EditPart child) {
        if (this.m_container.validateComponent(child.getModel())) {
            child.installEditPolicy("Selection Feedback", new NonResizableSelectionEditPolicy());
            new SelectionEditPolicyInstaller(this.m_model, child).decorate();
        }
    }

    @Override
    protected boolean isHorizontal(Request request) {
        return this.m_container.isHorizontal();
    }

    @Override
    protected ILayoutRequestValidator getRequestValidator() {
        return this.m_requestValidator;
    }

    @Override
    protected boolean isGoodReferenceChild(Request request, EditPart editPart) {
        Object referenceModel = editPart.getModel();
        return this.m_container.validateReference(referenceModel);
    }

    @Override
    protected void command_CREATE(Object newObject, Object referenceObject) throws Exception {
        this.m_container.command_CREATE(newObject, referenceObject);
    }

    @Override
    protected void command_MOVE(Object object, Object referenceObject) throws Exception {
        this.m_container.command_MOVE(object, referenceObject);
    }
}

