/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.gef.policy.selection.LineSelectionEditPolicy;
import org.eclipse.wb.core.model.IWrapper;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;

public class AbstractWrapperEditPart
extends GraphicalEditPart {
    private final IWrapper m_wrapper;

    public AbstractWrapperEditPart(IWrapper wrapper) {
        this.setModel(wrapper.getWrapperInfo());
        this.m_wrapper = wrapper;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", new LineSelectionEditPolicy(IColorConstants.black));
    }

    protected Figure createFigure() {
        return new Figure(){

            protected void paintClientArea(Graphics graphics) {
                graphics.drawImage(AbstractWrapperEditPart.this.m_wrapper.getWrapperInfo().getDescription().getIcon(), 0, 0);
            }
        };
    }

    protected void refreshVisuals() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                AbstractWrapperEditPart.this.refreshVisuals0();
            }
        });
    }

    private void refreshVisuals0() {
        Rectangle imageBounds = this.m_wrapper.getWrapperInfo().getDescription().getIcon().getBounds();
        int width = imageBounds.width;
        int height = imageBounds.height;
        org.eclipse.wb.draw2d.geometry.Rectangle parentClientArea = ((GraphicalEditPart)this.getParent()).getFigure().getClientArea();
        Point location = parentClientArea.getBottomRight().getTranslated(-width, -height);
        location.translate(-3, -3);
        org.eclipse.wb.draw2d.geometry.Rectangle bounds = new org.eclipse.wb.draw2d.geometry.Rectangle(location.x, location.y, width, height);
        this.getFigure().setBounds(bounds);
    }
}

