/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef;

import java.util.List;
import org.eclipse.wb.core.gef.IEditPartConfigurator;
import org.eclipse.wb.core.model.IWrapper;
import org.eclipse.wb.core.model.IWrapperInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartFactory;
import org.eclipse.wb.internal.core.gef.part.AbstractWrapperEditPart;
import org.eclipse.wb.internal.core.gef.part.DesignRootEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MenuEditPart;
import org.eclipse.wb.internal.core.gef.part.menu.MenuReference;
import org.eclipse.wb.internal.core.gef.part.nonvisual.ArrayObjectEditPart;
import org.eclipse.wb.internal.core.model.DesignRootObject;
import org.eclipse.wb.internal.core.model.nonvisual.AbstractArrayObjectInfo;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditPartFactory
implements IEditPartFactory {
    public static final EditPartFactory INSTANCE = new EditPartFactory();

    private EditPartFactory() {
    }

    @Override
    public EditPart createEditPart(EditPart context, Object model) {
        if (model == null) {
            return null;
        }
        if (model instanceof DesignRootObject) {
            DesignRootObject designRootObject = (DesignRootObject)model;
            return new DesignRootEditPart(designRootObject);
        }
        if (model instanceof MenuReference) {
            MenuReference reference = (MenuReference)model;
            MenuEditPart editPart = new MenuEditPart((Object)reference, reference.getMenu());
            EditPartFactory.configureEditPart(context, editPart);
            return editPart;
        }
        if (model instanceof AbstractArrayObjectInfo) {
            AbstractArrayObjectInfo arrayInfo = (AbstractArrayObjectInfo)model;
            ArrayObjectEditPart editPart = new ArrayObjectEditPart(arrayInfo);
            EditPartFactory.configureEditPart(context, editPart);
            return editPart;
        }
        for (IEditPartFactory factory : EditPartFactory.getFactories()) {
            EditPart editPart = factory.createEditPart(context, model);
            if (editPart == null) continue;
            EditPartFactory.configureEditPart(context, editPart);
            return editPart;
        }
        if (model instanceof IWrapperInfo) {
            IWrapper wrapper = ((IWrapperInfo)model).getWrapper();
            AbstractWrapperEditPart editPart = new AbstractWrapperEditPart(wrapper);
            EditPartFactory.configureEditPart(context, editPart);
            return editPart;
        }
        return null;
    }

    private static List<IEditPartFactory> getFactories() {
        return ExternalFactoriesHelper.getElementsInstances(IEditPartFactory.class, "org.eclipse.wb.core.editPartFactories", "factory");
    }

    public static void configureEditPart(EditPart context, EditPart editPart) {
        List<IEditPartConfigurator> configurators = ExternalFactoriesHelper.getElementsInstances(IEditPartConfigurator.class, "org.eclipse.wb.core.editPartConfigurators", "configurator");
        for (IEditPartConfigurator configurator : configurators) {
            configurator.configure(context, editPart);
        }
    }
}

