/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.command.Command;
import org.eclipse.wb.internal.core.editor.palette.command.ComponentAddCommand;
import org.eclipse.wb.internal.core.editor.palette.dialogs.ComponentAbstractDialog;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;

public final class ComponentAddDialog
extends ComponentAbstractDialog {
    private final PaletteInfo m_palette;
    private final CategoryInfo m_initialCategory;
    private ComboDialogField m_categoryField;

    public ComponentAddDialog(Shell parentShell, AstEditor editor, PaletteInfo palette, CategoryInfo initialCategory) {
        super(parentShell, editor, Messages.ComponentAddDialog_title, Messages.ComponentAddDialog_message);
        this.m_palette = palette;
        this.m_initialCategory = initialCategory;
    }

    protected void createControls(Composite container) {
        super.createControls(container);
        this.m_visibleField.setSelection(true);
        this.m_categoryField = ComponentAddDialog.createCategoryField(this.m_palette, this.m_initialCategory);
        this.doCreateField(this.m_categoryField, Messages.ComponentAddDialog_category);
    }

    protected Command createCommand() {
        String id = "custom_" + System.currentTimeMillis();
        String name = this.m_nameField.getText().trim();
        String description = this.getDescriptionText();
        boolean hidden = this.m_visibleField.getSelection();
        String className = this.m_classField.getText();
        CategoryInfo category = this.m_palette.getCategories().get(this.m_categoryField.getSelectionIndex());
        return new ComponentAddCommand(id, name, description, hidden, className, category);
    }
}

