/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.multi;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wb.core.editor.IEditorPage;
import org.eclipse.wb.internal.core.editor.multi.DesignerEditor;
import org.eclipse.wb.internal.core.editor.multi.MultiMode;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.TabFolderDecorator;

abstract class DefaultMultiMode
extends MultiMode {
    protected CTabFolder m_folder;
    protected IEditorPage m_activePage;

    public DefaultMultiMode(DesignerEditor editor) {
        super(editor);
    }

    protected final void createTabFolder(Composite parent) {
        this.m_folder = new CTabFolder(parent, 1024);
        TabFolderDecorator.decorate((IWorkbenchPart)this.m_editor, this.m_folder);
        this.m_folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DefaultMultiMode.this.showPage((IEditorPage)e.item.getData());
            }
        });
        this.m_folder.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                switch (e.detail) {
                    case 256: 
                    case 512: {
                        final int detail = e.detail;
                        e.doit = true;
                        e.detail = 0;
                        ExecutionUtils.runIgnore(new RunnableEx(){

                            public void run() throws Exception {
                                Composite control = (this).DefaultMultiMode.this.m_folder.getParent();
                                ReflectionUtils.invokeMethod(control, "traverse(int,org.eclipse.swt.widgets.Event)", detail, new Event());
                            }
                        });
                    }
                }
            }
        });
    }

    protected final CTabItem createTab(IEditorPage page) {
        CTabItem item = new CTabItem(this.m_folder, 0);
        item.setData((Object)page);
        item.setText(page.getName());
        item.setImage(page.getImage());
        item.setControl(page.createControl((Composite)this.m_folder));
        return item;
    }

    protected final void showPage(IEditorPage page) {
        if (this.m_activePage == page) {
            return;
        }
        if (this.m_activePage != null) {
            this.m_activePage.handleActiveState(false);
        }
        if (this.m_folder != null) {
            CTabItem[] cTabItemArray = this.m_folder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (item.getData() == page) {
                    this.m_folder.setSelection(item);
                }
                ++n2;
            }
        }
        this.m_activePage = page;
        this.m_activePage.handleActiveState(true);
        this.m_activePage.setFocus();
        this.handleShowPage();
    }

    protected void handleShowPage() {
    }

    public final boolean isSourceActive() {
        return this.m_activePage == this.m_sourcePage;
    }

    public final boolean isDesignActive() {
        return this.m_activePage == this.m_designPage;
    }
}

