/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.actions.SwitchAction;
import org.eclipse.wb.internal.core.editor.errors.ErrorEntryInfo;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.SwtResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultipleConstructorsComposite
extends Composite {
    private final BrowserComposite m_browser;
    private final Label m_titleLabel;
    private final TableViewer m_constructorsViewer;
    private AstEditor m_editor;
    private TypeDeclaration m_typeDeclaration;

    public MultipleConstructorsComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.create(this);
        Composite titleComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)titleComposite).alignHL();
        GridLayoutFactory.create(titleComposite).columns(2).margins(10);
        Label label = new Label(titleComposite, 0);
        label.setImage(SwtResourceManager.getImage(2));
        this.m_titleLabel = new Label(titleComposite, 0);
        this.m_titleLabel.setFont(SwtResourceManager.getFont(this.getFont().getFontData()[0].getName(), 14, 1));
        this.m_browser = new BrowserComposite(this, 0);
        GridDataFactory.create((Control)this.m_browser).grab().fill();
        new Label((Composite)this, 0).setText(Messages.MultipleConstructorsComposite_listLabel);
        this.m_constructorsViewer = new TableViewer((Composite)this, 2560);
        Table table = this.m_constructorsViewer.getTable();
        GridDataFactory.create((Control)table).hintVC(10).grabH().fill();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        this.m_constructorsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.m_constructorsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_constructorsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MultipleConstructorsComposite.this.markSelectedConstructor();
            }
        });
        Composite buttonsComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)buttonsComposite).alignHR();
        GridLayoutFactory.create(buttonsComposite).columns(2).equalColumns().marginsH(0);
        Button selectButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)selectButton).fillH();
        selectButton.setText(Messages.MultipleConstructorsComposite_useButton);
        selectButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage("actions/errors/entry_point.png"));
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultipleConstructorsComposite.this.markSelectedConstructor();
            }
        });
        Button switchButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)switchButton).fillH();
        switchButton.setText(Messages.MultipleConstructorsComposite_switchButton);
        switchButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage("actions/errors/switch32.png"));
        switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new SwitchAction().run();
            }
        });
    }

    public void setException(MultipleConstructorsError e) {
        this.m_editor = e.getEditor();
        this.m_typeDeclaration = e.getTypeDeclaration();
        int code = 400;
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry(code, new String[0]);
        this.m_titleLabel.setText(entry.getTitle());
        this.m_browser.setText(DesignerExceptionUtils.getWarningHTML(entry));
        try {
            List<IMethod> constructors = this.getConstructors();
            this.m_constructorsViewer.setInput(constructors);
            this.m_constructorsViewer.getTable().setSelection(0);
        }
        catch (Throwable ex) {
            DesignerPlugin.log(ex);
        }
    }

    private List<IMethod> getConstructors() throws Exception {
        String typeName = AstNodeUtils.getFullyQualifiedName(this.m_typeDeclaration, false);
        IType type = this.m_editor.getJavaProject().findType(typeName);
        List<MethodDeclaration> constructors = AstNodeUtils.getConstructors(this.m_typeDeclaration);
        List<String> signatures = AstNodeUtils.getMethodSignatures(constructors);
        return CodeUtils.findMethods(type, signatures);
    }

    private void markSelectedConstructor() {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                MultipleConstructorsComposite.this.markSelectedConstructorEx();
            }
        });
    }

    private void markSelectedConstructorEx() throws Exception {
        IMethod constructorModel = (IMethod)GenericsUtils.first(this.m_constructorsViewer.getSelection());
        String constructorSignature = CodeUtils.getMethodSignature(constructorModel);
        MethodDeclaration constructor = AstNodeUtils.getMethodBySignature(this.m_typeDeclaration, constructorSignature);
        this.m_editor.setJavadocTagText((BodyDeclaration)constructor, "@wbp.parser.constructor", "");
        this.m_editor.commitChanges();
    }
}

