/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.editor.IContextMenuConstants;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.actions.DesignPageActions;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.gef.core.MultiSelectionContextMenuProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DesignContextMenuProvider
extends MultiSelectionContextMenuProvider
implements IContextMenuConstants {
    private final DesignPageActions m_pageActions;
    private List<ObjectInfo> m_selectedObjects;

    public static void addGroups(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.top"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.edit"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.edit2"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.events"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.events2"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.layout"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.constraints"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.inheritance"));
        manager.add((IContributionItem)new Separator("org.eclipse.wb.popup.group.additional"));
    }

    public DesignContextMenuProvider(IEditPartViewer viewer, DesignPageActions pageActions) {
        super(viewer);
        this.m_pageActions = pageActions;
    }

    @Override
    protected void preprocessSelection(List<EditPart> editParts) {
        super.preprocessSelection(editParts);
        this.m_selectedObjects = Lists.newArrayList();
        for (EditPart editPart : editParts) {
            if (!(editPart.getModel() instanceof ObjectInfo)) continue;
            this.m_selectedObjects.add((ObjectInfo)editPart.getModel());
        }
    }

    @Override
    protected void buildContextMenu(final EditPart editPart, final IMenuManager manager) {
        DesignContextMenuProvider.addGroups(manager);
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getCutAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getCopyAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getPasteAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit", this.m_pageActions.getDeleteAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit2", this.m_pageActions.getTestAction());
        manager.appendToGroup("org.eclipse.wb.popup.group.edit2", this.m_pageActions.getRefreshAction());
        if (editPart.getModel() instanceof ObjectInfo) {
            ExecutionUtils.runLog(new RunnableEx(){

                public void run() throws Exception {
                    ObjectInfo object = (ObjectInfo)editPart.getModel();
                    object.getBroadcastObject().addContextMenu(DesignContextMenuProvider.this.m_selectedObjects, object, manager);
                }
            });
        }
    }
}

