/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.flow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.AbstractCreateRequest;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.utils.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFlowLayoutEditPolicy
extends LayoutEditPolicy {
    private Polyline m_insertionLine;
    private EditPart m_reference = null;
    private boolean m_beforeReference = true;

    protected abstract boolean isHorizontal(Request var1);

    protected abstract boolean isGoodReferenceChild(Request var1, EditPart var2);

    private List<EditPart> getReferenceChildren(Request request) {
        List<EditPart> allChildren = this.getHost().getChildren();
        ArrayList referenceChildren = Lists.newArrayList();
        for (EditPart editPart : allChildren) {
            if (!this.isGoodReferenceChild(request, editPart)) continue;
            referenceChildren.add(editPart);
        }
        return referenceChildren;
    }

    @Override
    public Command getCommand(Request request) {
        Command command = super.getCommand(request);
        if (command == null) {
            command = this.getCommand(request, this.getReferenceObject(request));
        }
        return command;
    }

    protected Command getCommand(Request request, Object referenceObject) {
        return null;
    }

    private Object getReferenceObject(Request request) {
        EditPart reference = this.getInsertionReference(request);
        return reference != null ? reference.getModel() : null;
    }

    @Override
    protected final Command getCreateCommand(CreateRequest request) {
        return this.getCreateCommand(request.getNewObject(), this.getReferenceObject(request));
    }

    protected Command getCreateCommand(Object newObject, Object referenceObject) {
        return null;
    }

    @Override
    protected final Command getPasteCommand(PasteRequest request) {
        return this.getPasteCommand(request, this.getReferenceObject(request));
    }

    protected Command getPasteCommand(PasteRequest request, Object referenceObject) {
        return null;
    }

    @Override
    protected final Command getMoveCommand(ChangeBoundsRequest request) {
        if (request.getEditParts().size() == 1) {
            EditPart moveEditPart = request.getEditParts().get(0);
            EditPart referenceEditPart = this.getInsertionReference(request);
            List<EditPart> children = this.getReferenceChildren(request);
            if (children.contains(moveEditPart)) {
                if (referenceEditPart == null && children.indexOf(moveEditPart) == children.size() - 1) {
                    return Command.EMPTY;
                }
                if (children.indexOf(moveEditPart) + 1 == children.indexOf(referenceEditPart)) {
                    return Command.EMPTY;
                }
            }
            return this.getMoveCommand(moveEditPart.getModel(), this.getReferenceObject(request));
        }
        return null;
    }

    protected abstract Command getMoveCommand(Object var1, Object var2);

    @Override
    protected final Command getAddCommand(ChangeBoundsRequest request) {
        if (request.getEditParts().size() == 1) {
            EditPart editPart = request.getEditParts().get(0);
            return this.getAddCommand(editPart.getModel(), this.getReferenceObject(request));
        }
        return null;
    }

    protected Command getAddCommand(Object addObject, Object referenceObject) {
        return this.getMoveCommand(addObject, referenceObject);
    }

    @Override
    protected void showLayoutTargetFeedback(Request request) {
        int rowChildrenCount;
        final boolean horizontal = this.isHorizontal(request);
        List<EditPart> children = this.getReferenceChildren(request);
        if (children.isEmpty()) {
            this.m_reference = null;
            this.showLayoutTargetFeedback_noReference(horizontal);
            return;
        }
        Transposer transposer = new Transposer();
        transposer.setEnabled(!horizontal);
        Point p = transposer.t(AbstractFlowLayoutEditPolicy.getLocationFromRequest(request));
        List rowChildren = Lists.newArrayList();
        EditPart nearestEditPart = null;
        int minDistance = Integer.MAX_VALUE;
        for (EditPart child : children) {
            Rectangle childBounds = this.getAbsoluteBounds(horizontal, child);
            int distance = p.y < childBounds.y ? childBounds.y - p.y : (p.y > childBounds.bottom() ? p.y - childBounds.bottom() : 0);
            if (distance >= minDistance) continue;
            nearestEditPart = child;
            minDistance = distance;
        }
        rowChildren.add(nearestEditPart);
        Rectangle nearestBounds = this.getAbsoluteBounds(horizontal, nearestEditPart);
        int rowMinY = nearestBounds.y;
        int rowMaxY = nearestBounds.bottom();
        do {
            rowChildrenCount = rowChildren.size();
            for (EditPart child : children) {
                Rectangle childBounds;
                if (rowChildren.contains(child) || !AbstractFlowLayoutEditPolicy.intervalsIntersects(rowMinY, rowMaxY, childBounds.y, (childBounds = this.getAbsoluteBounds(horizontal, child)).bottom())) continue;
                rowChildren.add(child);
                rowMinY = Math.min(rowMinY, childBounds.y);
                rowMaxY = Math.max(rowMaxY, childBounds.bottom());
            }
        } while (rowChildren.size() != rowChildrenCount);
        Collections.sort(rowChildren, new Comparator<EditPart>(){

            @Override
            public int compare(EditPart part_1, EditPart part_2) {
                return ((AbstractFlowLayoutEditPolicy)AbstractFlowLayoutEditPolicy.this).getAbsoluteBounds((boolean)horizontal, (EditPart)part_1).x - ((AbstractFlowLayoutEditPolicy)AbstractFlowLayoutEditPolicy.this).getAbsoluteBounds((boolean)horizontal, (EditPart)part_2).x;
            }
        });
        this.m_reference = null;
        this.m_beforeReference = true;
        if (!rowChildren.isEmpty()) {
            for (EditPart child : rowChildren) {
                Rectangle bounds = this.getAbsoluteBounds(horizontal, child);
                if (p.x >= bounds.getCenter().x) continue;
                this.m_reference = child;
                this.m_beforeReference = true;
                break;
            }
            if (this.m_reference == null) {
                this.m_reference = (EditPart)rowChildren.get(rowChildren.size() - 1);
                this.m_beforeReference = false;
            }
        }
        if (this.m_reference != null) {
            int x;
            Rectangle bounds = this.getAbsoluteBounds(horizontal, this.m_reference);
            if (this.m_beforeReference) {
                int referenceIndex = rowChildren.indexOf(this.m_reference);
                if (referenceIndex != 0) {
                    EditPart prevReference = (EditPart)rowChildren.get(referenceIndex - 1);
                    Rectangle prevBounds = this.getAbsoluteBounds(horizontal, prevReference);
                    x = bounds.x - Math.min(3, (bounds.x - prevBounds.right()) / 2);
                } else {
                    x = bounds.x - 3;
                }
            } else {
                x = bounds.right() + 3;
            }
            Polyline feedbackLine = this.getLineFeedback();
            Point p1 = new Point(x, bounds.y - 4);
            p1 = transposer.t(p1);
            FigureUtils.translateAbsoluteToFigure(feedbackLine, p1);
            Point p2 = new Point(x, bounds.y + bounds.height + 4);
            p2 = transposer.t(p2);
            FigureUtils.translateAbsoluteToFigure(feedbackLine, p2);
            feedbackLine.setPoint(p1, 0);
            feedbackLine.setPoint(p2, 1);
        }
    }

    private void showLayoutTargetFeedback_noReference(boolean horizontal) {
        Point p2;
        Point p1;
        Polyline feedbackLine = this.getLineFeedback();
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = hostFigure.getBounds().getCopy();
        FigureUtils.translateFigureToAbsolute(hostFigure, bounds);
        if (horizontal) {
            p1 = new Point(bounds.x, bounds.y);
            p2 = new Point(bounds.x, bounds.bottom());
        } else {
            p1 = new Point(bounds.x, bounds.y);
            p2 = new Point(bounds.right(), bounds.y);
        }
        if (horizontal) {
            if (bounds.width > 20) {
                p1.x += 5;
                p2.x += 5;
            }
            if (bounds.height > 20) {
                p1.y += 5;
                p2.y -= 5;
            }
        } else {
            if (bounds.width > 20) {
                p1.x += 5;
                p2.x -= 5;
            }
            if (bounds.height > 20) {
                p1.y += 5;
                p2.y += 5;
            }
        }
        feedbackLine.setPoint(p1, 0);
        feedbackLine.setPoint(p2, 1);
    }

    @Override
    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.m_insertionLine != null) {
            this.removeFeedback(this.m_insertionLine);
            this.m_insertionLine = null;
        }
    }

    private Polyline getLineFeedback() {
        if (this.m_insertionLine == null) {
            this.m_insertionLine = new Polyline();
            this.m_insertionLine.setLineWidth(2);
            this.m_insertionLine.setForeground(IColorConstants.red);
            this.m_insertionLine.addPoint(new Point(0, 0));
            this.m_insertionLine.addPoint(new Point(0, 0));
            this.addFeedback(this.m_insertionLine);
        }
        return this.m_insertionLine;
    }

    private EditPart getInsertionReference(Request request) {
        List<EditPart> children = this.getReferenceChildren(request);
        if (this.m_reference == null) {
            return null;
        }
        EditPart reference = this.m_beforeReference ? this.m_reference : GenericsUtils.getNextOrNull(children, this.m_reference);
        if (request instanceof AbstractCreateRequest) {
            return reference;
        }
        List<EditPart> selectedEditParts = this.getHost().getViewer().getSelectedEditParts();
        int index = children.indexOf(reference);
        while (selectedEditParts.contains(reference)) {
            if (index == children.size() - 1) {
                return null;
            }
            reference = children.get(++index);
        }
        return reference;
    }

    private static boolean intervalsIntersects(int x11, int x12, int x21, int x22) {
        int x1 = Math.max(x11, x21);
        int x2 = Math.min(x12, x22);
        return x2 - x1 > 0;
    }

    private static Point getLocationFromRequest(Request request) {
        return ((IDropRequest)((Object)request)).getLocation();
    }

    private Rectangle getAbsoluteBounds(boolean horizontal, EditPart editPart) {
        Rectangle bounds = PolicyUtils.getAbsoluteBounds((GraphicalEditPart)editPart);
        if (!horizontal) {
            bounds.transpose();
        }
        return bounds;
    }
}

