/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui.wizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.IDynamicExtensionRegistry;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.core.WBToolkitRegistry;
import org.eclipse.wb.internal.discovery.ui.WBDiscoveryUiPlugin;
import org.eclipse.wb.internal.discovery.ui.wizard.WizardToolkitUtils;
import org.osgi.framework.Bundle;

public class DynamicRegistryHelper {
    private static DynamicRegistryHelper registryHelper;
    private IContributor contributor;
    private Object userToken;

    public static DynamicRegistryHelper getRegistryHelper() {
        if (registryHelper == null) {
            registryHelper = new DynamicRegistryHelper();
        }
        return registryHelper;
    }

    public void registerWizards() {
        if (this.contributor == null) {
            Bundle bundle = WBDiscoveryUiPlugin.getPlugin().getBundle();
            this.contributor = ContributorFactoryOSGi.createContributor((Bundle)bundle);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.userToken = ((ExtensionRegistry)registry).getTemporaryUserToken();
            boolean success = false;
            byte[] xmlData = this.createContributionXML();
            if (xmlData != null && xmlData.length > 0) {
                success = registry.addContribution((InputStream)new ByteArrayInputStream(xmlData), this.contributor, false, "WindowBuilder dynamic contributions", null, this.userToken);
            }
            if (!success) {
                this.contributor = null;
                this.userToken = null;
            }
        }
    }

    public void removeRegistrations() {
        if (this.contributor != null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            if (this.contributor != null && registry instanceof IDynamicExtensionRegistry) {
                IDynamicExtensionRegistry dRegistry = (IDynamicExtensionRegistry)registry;
                dRegistry.removeContributor(this.contributor, this.userToken);
                this.contributor = null;
                this.userToken = null;
            }
        }
    }

    private byte[] createContributionXML() {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        builder.append("<?eclipse version=\"3.4\"?>\n");
        builder.append("<plugin>\n");
        for (WBToolkit toolkit : WBToolkitRegistry.getRegistry().getToolkits()) {
            if (toolkit.isInstalled()) continue;
            builder.append("<extension point=\"org.eclipse.ui.newWizards\">\n");
            builder.append("<wizard\n");
            builder.append("category=\"org.eclipse.wb\"\n");
            builder.append("class=\"org.eclipse.wb.internal.discovery.ui.wizard.InstallToolkitWizard:" + toolkit.getId() + "\"\n");
            builder.append("icon=\"icons/wizard.gif\"\n");
            builder.append("id=\"org.eclipse.wb.internal.discovery.ui.wizard.InstallToolkitWizard\"\n");
            builder.append("name=\"" + WizardToolkitUtils.getTitle(toolkit) + "\">\n");
            builder.append("<description>" + WizardToolkitUtils.getDescription(toolkit) + "</description>\n");
            builder.append("</wizard>\n");
            builder.append("</extension>\n");
        }
        builder.append("</plugin>\n");
        try {
            return builder.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return builder.toString().getBytes();
        }
    }
}

