/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wb.internal.discovery.core.WBDiscoveryCorePlugin;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.core.WBToolkitRegistry;
import org.eclipse.wb.internal.discovery.ui.Messages;
import org.eclipse.wb.internal.discovery.ui.WBDiscoveryUiPlugin;
import org.eclipse.wb.internal.discovery.ui.preferences.ToolkitControl;
import org.eclipse.wb.internal.discovery.ui.util.BorderPainter;
import org.eclipse.wb.internal.discovery.ui.util.ProgressBarMonitor;
import org.eclipse.wb.internal.discovery.ui.wizard.DynamicRegistryHelper;

public class ToolkitsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
WBToolkitRegistry.IRegistryChangeListener {
    static final String PREFERENCE_PAGE_ID = "org.eclipse.wb.internal.discovery.ui.preferences.ToolkitsPreferencePage";
    private List<ToolkitControl> controls = new ArrayList<ToolkitControl>();
    private Button contributeWizardEntriesButton;
    private Button installButton;
    private Button uninstallButton;
    private ProgressBar progressBar;
    private Composite scrolledContents;

    public ToolkitsPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public ToolkitsPreferencePage(String title) {
        this();
        this.setTitle(title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        final Composite body = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(body);
        body.setFont(parent.getFont());
        Color bkColor = Display.getDefault().getSystemColor(25);
        Label label = new Label(body, 0);
        label.setText(Messages.ToolkitsPreferencePage_additionalToolkitsLabel);
        label.setLayoutData((Object)new GridData(768));
        final ScrolledComposite scrolledComposite = new ScrolledComposite(body, 2560);
        scrolledComposite.setBackground(bkColor);
        scrolledComposite.setAlwaysShowScrollBars(true);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 100).applyTo((Control)scrolledComposite);
        Composite buttonPanel = new Composite(body, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(buttonPanel);
        buttonPanel.setLayoutData((Object)new GridData(128));
        this.installButton = new Button(buttonPanel, 8);
        this.installButton.setText(Messages.ToolkitsPreferencePage_installButton);
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolkitsPreferencePage.this.installToolkits();
            }
        });
        this.uninstallButton = new Button(buttonPanel, 8);
        this.uninstallButton.setText(Messages.ToolkitsPreferencePage_uninstallButton);
        this.uninstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolkitsPreferencePage.this.uninstallToolkits();
            }
        });
        this.progressBar = new ProgressBar(body, 0);
        this.progressBar.setMaximum(100);
        this.progressBar.setSelection(35);
        this.progressBar.setLayoutData((Object)new GridData(768));
        this.progressBar.setVisible(false);
        Label separator = new Label(body, 258);
        separator.setLayoutData((Object)new GridData(768));
        this.contributeWizardEntriesButton = new Button(body, 32);
        this.contributeWizardEntriesButton.setText(Messages.ToolkitsPreferencePage_showUninstalled);
        this.contributeWizardEntriesButton.setSelection(WBDiscoveryUiPlugin.getPlugin().getContributeToWizards());
        if (WBDiscoveryUiPlugin.DEBUG) {
            separator = new Label(body, 258);
            separator.setLayoutData((Object)new GridData(768));
            Button checkForUpdatesButton = new Button(body, 8);
            checkForUpdatesButton.setText(Messages.ToolkitsPreferencePage_checkForUpdates);
            checkForUpdatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WBDiscoveryCorePlugin.getPlugin().checkForRegistryUpdates();
                }
            });
        }
        this.scrolledContents = new Composite((Composite)scrolledComposite, 0);
        this.scrolledContents.setBackground(bkColor);
        this.scrolledContents.setRedraw(false);
        try {
            this.createToolkitsContents(this.scrolledContents);
        }
        finally {
            this.scrolledContents.layout(true);
            this.scrolledContents.setRedraw(true);
        }
        Point size = this.scrolledContents.computeSize(body.getSize().x, -1, true);
        this.scrolledContents.setSize(size);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinWidth(100);
        scrolledComposite.setMinHeight(100);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setMinHeight(1);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = ToolkitsPreferencePage.this.scrolledContents.computeSize(body.getSize().x - 20, -1, true);
                ToolkitsPreferencePage.this.scrolledContents.setSize(size);
                scrolledComposite.setMinHeight(size.y);
                ToolkitsPreferencePage.this.updateScrollIncrements(scrolledComposite);
            }
        });
        scrolledComposite.setContent((Control)this.scrolledContents);
        Dialog.applyDialogFont((Control)body);
        this.updateInstallButtons();
        body.layout(true);
        WBToolkitRegistry.getRegistry().addRegistryListener((WBToolkitRegistry.IRegistryChangeListener)this);
        WBDiscoveryCorePlugin.getPlugin().checkForRegistryUpdates();
        return body;
    }

    private void updateScrollIncrements(ScrolledComposite scrolledComposite) {
        int pageInc = scrolledComposite.getBounds().height;
        scrolledComposite.getVerticalBar().setIncrement(20);
        scrolledComposite.getVerticalBar().setPageIncrement(pageInc);
    }

    public void handleRegistryChange() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ToolkitsPreferencePage.this.controls.clear();
                Control[] controlArray = ToolkitsPreferencePage.this.scrolledContents.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.dispose();
                    ++n2;
                }
                ToolkitsPreferencePage.this.createToolkitsContents(ToolkitsPreferencePage.this.scrolledContents);
            }
        });
    }

    public void dispose() {
        WBToolkitRegistry.getRegistry().removeRegistryListener((WBToolkitRegistry.IRegistryChangeListener)this);
        super.dispose();
    }

    public boolean performOk() {
        boolean oldValue;
        boolean contributeToWizards = this.contributeWizardEntriesButton.getSelection();
        if (contributeToWizards != (oldValue = WBDiscoveryUiPlugin.getPlugin().getContributeToWizards())) {
            WBDiscoveryUiPlugin.getPlugin().getPreferenceStore().setValue("contributeWizardEntries", contributeToWizards);
            if (contributeToWizards) {
                DynamicRegistryHelper.getRegistryHelper().registerWizards();
            } else {
                DynamicRegistryHelper.getRegistryHelper().removeRegistrations();
            }
        }
        return super.performOk();
    }

    private void createToolkitsContents(Composite composite) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(composite);
        List toolkits = WBToolkitRegistry.getRegistry().getToolkits();
        for (WBToolkit toolkit : toolkits) {
            final ToolkitControl toolkitControl = new ToolkitControl(composite, toolkit);
            this.controls.add(toolkitControl);
            toolkitControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ToolkitsPreferencePage.this.toolkitSelected(toolkitControl, e.stateMask);
                }
            });
            Composite border = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, false).hint(-1, 1).applyTo((Control)border);
            GridLayoutFactory.fillDefaults().applyTo(border);
            border.addPaintListener((PaintListener)new BorderPainter());
        }
        composite.layout(true);
        composite.redraw();
    }

    void toolkitSelected(ToolkitControl toolkitControl, int stateMask) {
        if (this.ctrlClicked(stateMask)) {
            toolkitControl.setSelected(!toolkitControl.isSelected());
        } else {
            toolkitControl.setSelected(true);
            for (ToolkitControl tk : this.controls) {
                if (tk == toolkitControl) continue;
                tk.setSelected(false);
            }
        }
        this.updateInstallButtons();
    }

    private void updateInstallButtons() {
        boolean installEnabled = false;
        boolean uninstallEnabled = false;
        if (this.getSelectionCount() > 0) {
            boolean installSelected = true;
            boolean uninstallSelected = true;
            for (ToolkitControl toolkitControl : this.controls) {
                if (!toolkitControl.isSelected()) continue;
                if (toolkitControl.getToolkit().isInstalled()) {
                    installSelected = false;
                    continue;
                }
                uninstallSelected = false;
            }
            installEnabled = installSelected;
            uninstallEnabled = uninstallSelected;
        }
        this.installButton.setEnabled(installEnabled);
        this.uninstallButton.setEnabled(uninstallEnabled);
    }

    private int getSelectionCount() {
        int count = 0;
        for (ToolkitControl toolkitControl : this.controls) {
            if (!toolkitControl.isSelected()) continue;
            ++count;
        }
        return count;
    }

    private boolean ctrlClicked(int stateMask) {
        return (SWT.MOD1 & stateMask) != 0;
    }

    private void installToolkits() {
        this.progressBar.setVisible(true);
        ArrayList<WBToolkit> toolkits = new ArrayList<WBToolkit>();
        for (ToolkitControl control : this.controls) {
            if (!control.isSelected()) continue;
            toolkits.add(control.getToolkit());
        }
        ProgressBarMonitor monitor = new ProgressBarMonitor(this.progressBar);
        try {
            WBDiscoveryUiPlugin.getPlugin().installToolkits(toolkits, monitor);
            this.closePreferencesDialog();
        }
        catch (ProvisionException e) {
            monitor.done();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolkitsPreferencePage_errorInstalling, (String)e.getMessage());
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void uninstallToolkits() {
        this.progressBar.setVisible(true);
        ArrayList<WBToolkit> toolkits = new ArrayList<WBToolkit>();
        for (ToolkitControl control : this.controls) {
            if (!control.isSelected()) continue;
            toolkits.add(control.getToolkit());
        }
        ProgressBarMonitor monitor = new ProgressBarMonitor(this.progressBar);
        try {
            WBDiscoveryUiPlugin.getPlugin().uninstallToolkits(toolkits, monitor);
            this.closePreferencesDialog();
        }
        catch (ProvisionException e) {
            monitor.done();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ToolkitsPreferencePage_errorUninstalling, (String)e.getCause().getMessage());
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void closePreferencesDialog() {
        if (this.getContainer() instanceof PreferenceDialog) {
            PreferenceDialog dialog = (PreferenceDialog)this.getContainer();
            dialog.close();
        }
    }
}

