/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.ui.preferences;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.eclipse.wb.internal.discovery.ui.Messages;
import org.eclipse.wb.internal.discovery.ui.WBDiscoveryUiPlugin;
import org.eclipse.wb.internal.discovery.ui.util.BrowserHelper;

class ToolkitControl
extends Composite {
    private static Font BOLD_FONT;
    private boolean selected;
    private WBToolkit wbToolkit;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public ToolkitControl(Composite parent, WBToolkit wbToolkit) {
        super(parent, 0);
        this.wbToolkit = wbToolkit;
        this.setLayoutData(new GridData(768));
        this.setBackground(parent.getBackground());
        this.initControl();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean value) {
        this.selected = value;
        this.updateBackground();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSelectionEvent(MouseEvent me) {
        Event e = new Event();
        e.widget = this;
        SelectionEvent event = new SelectionEvent(e);
        event.stateMask = me.stateMask;
        event.widget = this;
        for (SelectionListener listener : this.listeners) {
            listener.widgetSelected(event);
        }
    }

    protected WBToolkit getToolkit() {
        return this.wbToolkit;
    }

    private void initControl() {
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(3, 2).extendedMargins(5, 0, 4, 2).spacing(5, 0).applyTo((Composite)this);
        this.listenTo((Control)this);
        Label iconLabel = new Label((Composite)this, 0);
        iconLabel.setBackground(this.getBackground());
        GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).indent(0, 2).applyTo((Control)iconLabel);
        this.listenTo((Control)iconLabel);
        if (this.wbToolkit.getIconURL() != null) {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)this.wbToolkit.getIconURL());
            iconLabel.setImage(WBDiscoveryUiPlugin.getImage(descriptor));
        }
        Label nameLabel = new Label((Composite)this, 0);
        nameLabel.setText(this.wbToolkit.getTitle());
        nameLabel.setBackground(this.getBackground());
        nameLabel.setLayoutData((Object)new GridData(768));
        nameLabel.setFont(ToolkitControl.getBoldFont(this.getFont()));
        this.listenTo((Control)nameLabel);
        Label providerLabel = new Label((Composite)this, 0);
        providerLabel.setText(this.wbToolkit.getProviderDescription());
        providerLabel.setLayoutData((Object)new GridData(128));
        providerLabel.setBackground(this.getBackground());
        providerLabel.setForeground(Display.getDefault().getSystemColor(15));
        this.listenTo((Control)providerLabel);
        Label summaryLabel = new Label((Composite)this, 64);
        String description = this.wbToolkit.getDescription();
        description = description.replaceAll("(\\r\\n)|\\n|\\r", " ");
        summaryLabel.setText(description);
        summaryLabel.setBackground(this.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, -1).applyTo((Control)summaryLabel);
        this.listenTo((Control)summaryLabel);
        if (this.wbToolkit.getMoreInfoURL() != null) {
            ++((GridData)iconLabel.getLayoutData()).verticalSpan;
            Link moreInfoLink = new Link((Composite)this, 0);
            moreInfoLink.setText(Messages.ToolkitControl_moreInfoLink);
            moreInfoLink.setBackground(this.getBackground());
            moreInfoLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    BrowserHelper.openUrl(ToolkitControl.this.getShell(), ToolkitControl.this.wbToolkit.getMoreInfoURL());
                }
            });
            GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)moreInfoLink);
            Label label = new Label((Composite)this, 0);
            label.setBackground(this.getBackground());
            this.listenTo((Control)label);
        }
        if (this.wbToolkit.isInstalled()) {
            nameLabel.setText(String.valueOf(nameLabel.getText()) + Messages.ToolkitControl_installedStatus);
            summaryLabel.setForeground(Display.getDefault().getSystemColor(15));
        }
    }

    private void listenTo(Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolkitControl.this.fireSelectionEvent(e);
            }
        });
    }

    private static Font getBoldFont(Font font) {
        if (BOLD_FONT == null) {
            FontData data = font.getFontData()[0];
            data.setStyle(1);
            BOLD_FONT = new Font((Device)Display.getDefault(), data);
        }
        return BOLD_FONT;
    }

    private void updateBackground() {
        Color background = this.isSelected() ? Display.getDefault().getSystemColor(26) : Display.getDefault().getSystemColor(1);
        this.updateBackground(this, background);
    }

    private void updateBackground(Composite composite, Color background) {
        composite.setBackground(background);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                this.updateBackground((Composite)control, background);
            } else {
                control.setBackground(background);
            }
            ++n2;
        }
    }
}

