/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.property.UniqueEmployeeName;
import org.eclipse.ve.examples.cdm.dept.ui.AddEmployeesCommand;
import org.eclipse.ve.examples.cdm.dept.ui.CompanyAnnotationLinkagePolicy;
import org.eclipse.ve.examples.cdm.dept.ui.RemoveEmployeesCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.propertysheet.command.RestoreDefaultPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class DepartmentContainerPolicy
extends ContainerPolicy {
    public DepartmentContainerPolicy(EditDomain domain) {
        super(domain);
    }

    public Command getAddCommand(List children, Object position) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (!(child instanceof Employee)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (!this.container.equals(((Employee)child).getManages())) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return new AddEmployeesCommand((Department)this.container, children, (Employee)position);
    }

    public Command getCreateCommand(Object child, Object position) {
        if (!(child instanceof Employee)) {
            return UnexecutableCommand.INSTANCE;
        }
        Department parent = (Department)this.container;
        List<Object> children = Collections.singletonList(child);
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new UniqueEmployeeName(parent.getCompany(), (Employee)child));
        cc.append((Command)new AddEmployeesCommand(parent, children, (Employee)position));
        return AnnotationPolicy.getCreateRequestCommand((List)AnnotationPolicy.getAllAnnotations(new ArrayList(), (Object)child, (AnnotationLinkagePolicy)this.domain.getAnnotationLinkagePolicy()), (Command)cc, (EditDomain)this.domain);
    }

    public Command getDeleteDependentCommand(Object child) {
        if (!(child instanceof Employee)) {
            return UnexecutableCommand.INSTANCE;
        }
        Department parent = (Department)this.container;
        List<Object> list = Collections.singletonList(child);
        List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), (Object)child, (AnnotationLinkagePolicy)this.domain.getAnnotationLinkagePolicy());
        RemoveEmployeesCommand cmd = new RemoveEmployeesCommand(parent, list);
        if (((Employee)child).getManages() != null) {
            RestoreDefaultPropertyValueCommand umCmd = new RestoreDefaultPropertyValueCommand();
            umCmd.setTarget(PropertySupport.getPropertySource(((Employee)child).getManages()));
            umCmd.setPropertyId((Object)"manager");
            cmd = umCmd.chain((Command)cmd);
            Annotation mgrConn = this.domain.getAnnotationLinkagePolicy().getAnnotation((Object)new CompanyAnnotationLinkagePolicy.ManagedConnection(((Employee)child).getManages()));
            if (mgrConn != null) {
                annotations.add(mgrConn);
            }
        }
        return AnnotationPolicy.getDeleteDependentCommand((List)annotations, (Command)cmd, (DiagramData)this.domain.getDiagramData());
    }

    public Command getMoveChildrenCommand(List children, Object position) {
        CommandBuilder cBld = new CommandBuilder("");
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Employee) continue;
            return UnexecutableCommand.INSTANCE;
        }
        if (children.contains(position)) {
            return UnexecutableCommand.INSTANCE;
        }
        Department parent = (Department)this.container;
        cBld.append((Command)new RemoveEmployeesCommand(parent, children));
        cBld.append((Command)new AddEmployeesCommand(parent, children, (Employee)position));
        return cBld.getCommand();
    }

    protected Command getOrphanTheChildrenCommand(List children) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Employee) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return new RemoveEmployeesCommand((Department)this.container, children);
    }
}

