/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.property;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.internal.propertysheet.EToolsPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.ISourced;
import org.eclipse.ve.internal.propertysheet.StandardComboBoxCellEditor;
import org.eclipse.ve.internal.propertysheet.StringPropertyDescriptor;

public class DepartmentPropertySource
implements IPropertySource {
    protected Department department;
    protected IPropertyDescriptor[] descriptors;

    public DepartmentPropertySource(Department department) {
        this.department = department;
    }

    public Object getEditableValue() {
        return this.department;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new IPropertyDescriptor[]{new StringPropertyDescriptor((Object)"deptname", "department name"), new ManagerPropertyDescriptor("manager", "department manager")};
            StringPropertyDescriptor pd = (StringPropertyDescriptor)this.descriptors[0];
            pd.setValidator((ICellEditorValidator)new NameValidator());
            pd.setAlwaysIncompatible(true);
            ((ManagerPropertyDescriptor)this.descriptors[1]).setNullInvalid(false);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object propertyKey) {
        if ("deptname".equals(propertyKey)) {
            return this.department.getDepartmentName();
        }
        if ("manager".equals(propertyKey)) {
            return this.department.getManager();
        }
        return null;
    }

    public boolean isPropertySet(Object propertyKey) {
        if ("deptname".equals(propertyKey)) {
            return this.department.getDepartmentName() != null;
        }
        if ("manager".equals(propertyKey)) {
            return this.department.getManager() != null;
        }
        return false;
    }

    public void resetPropertyValue(Object propertyKey) {
        if ("deptname".equals(propertyKey)) {
            this.department.setDepartmentName(null);
        } else if ("manager".equals(propertyKey)) {
            this.department.setManager(null);
        }
    }

    public void setPropertyValue(Object propertyKey, Object value) {
        if (value instanceof String && "deptname".equals(propertyKey)) {
            this.department.setDepartmentName((String)value);
        }
        if ((value == null || value instanceof Employee) && "manager".equals(propertyKey)) {
            this.department.setManager((Employee)value);
        }
    }

    private class NameValidator
    implements ICellEditorValidator {
        NameValidator() {
        }

        public String isValid(Object value) {
            if (value == null) {
                return null;
            }
            String name = (String)value;
            if (name.length() == 0) {
                return "There must be a name.";
            }
            if (name.equals(DepartmentPropertySource.this.department.getDepartmentName())) {
                return null;
            }
            String newName = PropertySupport.getUniqueDepartmentName(DepartmentPropertySource.this.department.getCompany(), name);
            if (newName.equals(name)) {
                return null;
            }
            return "The name is not unique.";
        }
    }

    private static class ManagerCellEditor
    extends StandardComboBoxCellEditor
    implements ISourced {
        Department source;

        public ManagerCellEditor(Composite parent) {
            super(parent);
        }

        public void setSources(Object[] sources, IPropertySource[] pos, IPropertyDescriptor[] des) {
            this.source = (Department)sources[0];
            ArrayList<Employee> employees = new ArrayList<Employee>();
            ArrayList<String> employeeStrings = new ArrayList<String>();
            Employee manager = this.source.getManager();
            if (manager != null) {
                employees.add(manager);
                employeeStrings.add(manager.toString());
            }
            Iterator itr = this.source.getCompany().getEmployeesIterator();
            while (itr.hasNext()) {
                Employee e = (Employee)itr.next();
                if (e.getManages() != null || e.getDepartment() == this.source) continue;
                employees.add(e);
                employeeStrings.add(e.toString());
            }
            employees.add(null);
            employeeStrings.add("<No manager>");
            this.setItems(employeeStrings.toArray(new String[employeeStrings.size()]), employees.toArray());
        }
    }

    private static class ManagerPropertyDescriptor
    extends EToolsPropertyDescriptor {
        public ManagerPropertyDescriptor(Object id, String displayName) {
            super(id, displayName);
            this.setAlwaysIncompatible(true);
        }

        public CellEditor createPropertyEditor(Composite parent) {
            ManagerCellEditor editor = new ManagerCellEditor(parent);
            ICellEditorValidator v = this.getValidator();
            if (v != null) {
                editor.setValidator(v);
            }
            return editor;
        }
    }
}

