/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;

public class SharedReaderProvider
implements ReaderProvider {
    private static Field subReadersField;
    private static Log log;
    private Lock semaphoreIndexReaderLock = new ReentrantLock();
    private Map<DirectoryProvider, Lock> perDirectoryProviderManipulationLocks;
    private Map<DirectoryProvider, IndexReader> activeSearchIndexReaders = new HashMap<DirectoryProvider, IndexReader>();
    private Map<IndexReader, ReaderData> searchIndexReaderSemaphores = new HashMap<IndexReader, ReaderData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader openReader(DirectoryProvider[] directoryProviders) {
        boolean trace = log.isTraceEnabled();
        int length = directoryProviders.length;
        IndexReader[] readers = new IndexReader[length];
        if (trace) {
            log.trace((Object)("Opening IndexReader for directoryProviders: " + length));
        }
        for (int index = 0; index < length; ++index) {
            IndexReader reader;
            DirectoryProvider directoryProvider = directoryProviders[index];
            Lock directoryProviderLock = this.perDirectoryProviderManipulationLocks.get(directoryProvider);
            if (trace) {
                log.trace((Object)("Opening IndexReader from " + directoryProvider.getDirectory().toString()));
            }
            directoryProviderLock.lock();
            try {
                reader = this.activeSearchIndexReaders.get(directoryProvider);
            }
            finally {
                directoryProviderLock.unlock();
            }
            if (reader == null) {
                if (trace) {
                    log.trace((Object)("No shared IndexReader, opening a new one: " + directoryProvider.getDirectory().toString()));
                }
                reader = this.replaceActiveReader(null, directoryProviderLock, directoryProvider, readers);
            } else {
                boolean isCurrent;
                try {
                    isCurrent = reader.isCurrent();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to read current status of Lucene IndexReader", e);
                }
                if (!isCurrent) {
                    if (trace) {
                        log.trace((Object)("Out of date shared IndexReader found, opening a new one: " + directoryProvider.getDirectory().toString()));
                    }
                    IndexReader outOfDateReader = reader;
                    reader = this.replaceActiveReader(outOfDateReader, directoryProviderLock, directoryProvider, readers);
                } else {
                    if (trace) {
                        log.trace((Object)("Valid shared IndexReader: " + directoryProvider.getDirectory().toString()));
                    }
                    directoryProviderLock.lock();
                    try {
                        reader = this.activeSearchIndexReaders.get(directoryProvider);
                        this.semaphoreIndexReaderLock.lock();
                        try {
                            ReaderData readerData = this.searchIndexReaderSemaphores.get(reader);
                            ++readerData.semaphore;
                            this.searchIndexReaderSemaphores.put(reader, readerData);
                            if (trace) {
                                log.trace((Object)("Semaphore increased: " + readerData.semaphore + " for " + reader));
                            }
                        }
                        finally {
                            this.semaphoreIndexReaderLock.unlock();
                        }
                    }
                    finally {
                        directoryProviderLock.unlock();
                    }
                }
            }
            readers[index] = reader;
        }
        return ReaderProviderHelper.buildMultiReader(length, readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader replaceActiveReader(IndexReader outOfDateReader, Lock directoryProviderLock, DirectoryProvider directoryProvider, IndexReader[] readers) {
        IndexReader oldReader;
        IndexReader reader;
        boolean trace = log.isTraceEnabled();
        boolean closeOldReader = false;
        boolean closeOutOfDateReader = false;
        try {
            reader = IndexReader.open(directoryProvider.getDirectory());
        }
        catch (IOException e) {
            throw new SearchException("Unable to open Lucene IndexReader", e);
        }
        directoryProviderLock.lock();
        try {
            oldReader = this.activeSearchIndexReaders.put(directoryProvider, reader);
            this.semaphoreIndexReaderLock.lock();
            try {
                ReaderData readerData;
                this.searchIndexReaderSemaphores.put(reader, new ReaderData(1, directoryProvider));
                if (trace) {
                    log.trace((Object)("Semaphore: 1 for " + reader));
                }
                if (outOfDateReader != null) {
                    readerData = this.searchIndexReaderSemaphores.get(outOfDateReader);
                    if (readerData == null) {
                        closeOutOfDateReader = false;
                    } else if (readerData.semaphore == 0) {
                        this.searchIndexReaderSemaphores.remove(outOfDateReader);
                        closeOutOfDateReader = true;
                    } else {
                        closeOutOfDateReader = false;
                    }
                }
                if (oldReader != null && oldReader != outOfDateReader) {
                    readerData = this.searchIndexReaderSemaphores.get(oldReader);
                    if (readerData == null) {
                        log.warn((Object)"Semaphore should not be null");
                        closeOldReader = true;
                    } else if (readerData.semaphore == 0) {
                        this.searchIndexReaderSemaphores.remove(oldReader);
                        closeOldReader = true;
                    } else {
                        closeOldReader = false;
                    }
                }
            }
            finally {
                this.semaphoreIndexReaderLock.unlock();
            }
        }
        finally {
            directoryProviderLock.unlock();
        }
        if (closeOutOfDateReader) {
            if (trace) {
                log.trace((Object)("Closing out of date IndexReader " + outOfDateReader));
            }
            try {
                outOfDateReader.close();
            }
            catch (IOException e) {
                ReaderProviderHelper.clean(new SearchException("Unable to close Lucene IndexReader", e), readers);
            }
        }
        if (closeOldReader) {
            if (trace) {
                log.trace((Object)("Closing old IndexReader " + oldReader));
            }
            try {
                oldReader.close();
            }
            catch (IOException e) {
                ReaderProviderHelper.clean(new SearchException("Unable to close Lucene IndexReader", e), readers);
            }
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReader(IndexReader reader) {
        IndexReader[] readers;
        boolean trace = log.isTraceEnabled();
        if (reader == null) {
            return;
        }
        if (reader instanceof MultiReader) {
            try {
                readers = (IndexReader[])subReadersField.get(reader);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Incompatible version of Lucene: MultiReader.subReaders not accessible", e);
            }
            if (trace) {
                log.trace((Object)("Closing MultiReader: " + reader));
            }
        } else {
            throw new AssertionFailure("Everything should be wrapped in a MultiReader");
        }
        for (IndexReader subReader : readers) {
            ReaderData readerData;
            this.semaphoreIndexReaderLock.lock();
            try {
                readerData = this.searchIndexReaderSemaphores.get(subReader);
            }
            finally {
                this.semaphoreIndexReaderLock.unlock();
            }
            if (readerData == null) {
                log.error((Object)("Trying to close a Lucene IndexReader not present: " + subReader.directory().toString()));
                continue;
            }
            Lock directoryProviderLock = this.perDirectoryProviderManipulationLocks.get(readerData.provider);
            boolean closeReader = false;
            directoryProviderLock.lock();
            try {
                boolean isActive;
                boolean bl = isActive = this.activeSearchIndexReaders.get(readerData.provider) == subReader;
                if (trace) {
                    log.trace((Object)("Indexreader not active: " + subReader));
                }
                this.semaphoreIndexReaderLock.lock();
                try {
                    readerData = this.searchIndexReaderSemaphores.get(subReader);
                    if (readerData == null) {
                        log.error((Object)("Trying to close a Lucene IndexReader not present: " + subReader.directory().toString()));
                        continue;
                    }
                    --readerData.semaphore;
                    if (trace) {
                        log.trace((Object)("Semaphore decreased to: " + readerData.semaphore + " for " + subReader));
                    }
                    if (readerData.semaphore < 0) {
                        log.error((Object)("Semaphore negative: " + subReader.directory().toString()));
                    }
                    if (!isActive && readerData.semaphore == 0) {
                        this.searchIndexReaderSemaphores.remove(subReader);
                        closeReader = true;
                    } else {
                        closeReader = false;
                    }
                }
                finally {
                    this.semaphoreIndexReaderLock.unlock();
                }
            }
            finally {
                directoryProviderLock.unlock();
            }
            if (!closeReader) continue;
            if (trace) {
                log.trace((Object)("Closing IndexReader: " + subReader));
            }
            try {
                subReader.close();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close Lucene IndexReader", (Throwable)e);
            }
        }
    }

    public void initialize(Properties props, SearchFactoryImplementor searchFactoryImplementor) {
        if (subReadersField == null) {
            try {
                subReadersField = MultiReader.class.getDeclaredField("subReaders");
                if (!subReadersField.isAccessible()) {
                    subReadersField.setAccessible(true);
                }
            }
            catch (NoSuchFieldException e) {
                throw new SearchException("Incompatible version of Lucene: MultiReader.subReaders not accessible", e);
            }
        }
        Set<DirectoryProvider> providers = searchFactoryImplementor.getLockableDirectoryProviders().keySet();
        this.perDirectoryProviderManipulationLocks = new HashMap<DirectoryProvider, Lock>(providers.size());
        for (DirectoryProvider dp : providers) {
            this.perDirectoryProviderManipulationLocks.put(dp, new ReentrantLock());
        }
        this.perDirectoryProviderManipulationLocks = Collections.unmodifiableMap(this.perDirectoryProviderManipulationLocks);
    }

    static {
        log = LogFactory.getLog(SharedReaderProvider.class);
    }

    private class ReaderData {
        public int semaphore;
        public DirectoryProvider provider;

        public ReaderData(int semaphore, DirectoryProvider provider) {
            this.semaphore = semaphore;
            this.provider = provider;
        }
    }
}

