/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class ObjectLoader
implements Loader {
    private static final Log log = LogFactory.getLog(ObjectLoader.class);
    private Session session;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
    }

    public Object load(EntityInfo entityInfo) {
        Object maybeProxy = this.session.get(entityInfo.clazz, entityInfo.id);
        try {
            Hibernate.initialize((Object)maybeProxy);
        }
        catch (ObjectNotFoundException e) {
            log.debug((Object)("Object found in Search index but not in database: " + e.getEntityName() + " wih id " + e.getIdentifier()));
            maybeProxy = null;
        }
        return maybeProxy;
    }

    public List load(EntityInfo ... entityInfos) {
        for (EntityInfo entityInfo : entityInfos) {
            this.session.load(entityInfo.clazz, entityInfo.id);
        }
        ArrayList<Object> result = new ArrayList<Object>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            try {
                Object entity = this.session.load(entityInfo.clazz, entityInfo.id);
                Hibernate.initialize((Object)entity);
                result.add(entity);
            }
            catch (ObjectNotFoundException e) {
                log.debug((Object)("Object found in Search index but not in database: " + e.getEntityName() + " wih id " + e.getIdentifier()));
            }
        }
        return result;
    }
}

