/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.hibernate.eclipse.launch.core.refactoring.HibernateRefactoringUtil;

public class LaunchConfigurationResourceNameChange
extends Change {
    private ILaunchConfiguration fLaunchConfiguration;
    private IPath fOldPath;
    private IPath fNewPath;

    LaunchConfigurationResourceNameChange(ILaunchConfiguration launchConfiguration, IPath oldPath, IPath newPath) {
        this.fLaunchConfiguration = launchConfiguration;
        this.fOldPath = oldPath;
        this.fNewPath = newPath;
    }

    public Object getModifiedElement() {
        return this.fLaunchConfiguration;
    }

    public String getName() {
        return "Update resource path in launch configuration " + this.fLaunchConfiguration.getName();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (!this.fLaunchConfiguration.exists()) {
            IPath newLaunchPath;
            IFile[] files;
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IPath rootLoacation = root.getLocation();
            IPath oldConfigLocation = this.fLaunchConfiguration.getLocation();
            int matchSegment = oldConfigLocation.matchingFirstSegments(rootLoacation);
            IPath relativePath = oldConfigLocation.removeFirstSegments(matchSegment);
            if (HibernateRefactoringUtil.isAttributeChanged((relativePath = relativePath.setDevice(null).makeAbsolute()).toOSString(), this.fOldPath) && (files = root.findFilesForLocation(rootLoacation.append(newLaunchPath = this.fNewPath.append(relativePath.removeFirstSegments(matchSegment = relativePath.matchingFirstSegments(this.fOldPath)))))).length > 0) {
                this.fLaunchConfiguration = DebugPlugin.getDefault().getLaunchManager().getLaunchConfiguration(files[0]);
            }
        }
        this.fLaunchConfiguration = HibernateRefactoringUtil.updateLaunchConfig(this.fLaunchConfiguration, this.fOldPath, this.fNewPath);
        return new LaunchConfigurationResourceNameChange(this.fLaunchConfiguration, this.fNewPath, this.fOldPath);
    }
}

