/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;

public class DirectoryBrowseField
extends StringDialogField {
    protected Button filesystemBrowse;
    protected Button workspaceBrowse;
    protected String filesystemBrowseLabel = "Filesystem...";
    protected String workspaceBrowseLabel = "Workspace..";
    protected IPath initialFilesystemPath;
    protected IPath initialWorkspacePath;
    protected String dialogTitle;
    protected String dialogDescription;

    public DirectoryBrowseField(IPath initialFilesystemPath, IPath initialWorkspacePath, String dialogTitle, String dialogDescription) {
        this.initialFilesystemPath = initialFilesystemPath;
        this.initialWorkspacePath = initialWorkspacePath;
        this.dialogTitle = dialogTitle;
        this.dialogDescription = dialogDescription;
    }

    protected void updateEnableState() {
        super.updateEnableState();
        boolean enabled = this.isEnabled();
        if (this.filesystemBrowse != null) {
            this.filesystemBrowse.setEnabled(enabled);
        }
        if (this.workspaceBrowse != null) {
            this.workspaceBrowse.setEnabled(enabled);
        }
    }

    protected static GridData gridDataForButton(Button button, int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.widthHint = SWTUtil.getButtonWidthHint((Button)button);
        return gd;
    }

    public int getNumberOfControls() {
        return 4;
    }

    public Control[] doFillIntoGrid(Composite parent, int columns) {
        this.assertEnoughColumns(columns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DirectoryBrowseField.gridDataForLabel((int)1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)DirectoryBrowseField.gridDataForText((int)(columns - 3)));
        Button filesystemButton = this.getFilesystemBrowseButton(parent);
        filesystemButton.setLayoutData((Object)DirectoryBrowseField.gridDataForButton(filesystemButton, 1));
        Button workspaceButton = this.getWorkspaceBrowseButton(parent);
        filesystemButton.setLayoutData((Object)DirectoryBrowseField.gridDataForButton(workspaceButton, 1));
        return new Control[]{label, text, filesystemButton, workspaceButton};
    }

    protected void browseFilesystem() {
        String dir;
        DirectoryDialog dialog = new DirectoryDialog(this.filesystemBrowse.getShell());
        dialog.setText(this.dialogTitle);
        dialog.setMessage(this.dialogDescription);
        if (this.initialFilesystemPath != null) {
            dialog.setFilterPath(this.initialFilesystemPath.toOSString());
        }
        if ((dir = dialog.open()) != null) {
            this.setText(dir);
        }
    }

    protected void browseWorkspace() {
        IPath[] paths = DialogSelectionHelper.chooseFolderEntries(this.filesystemBrowse.getShell(), this.initialWorkspacePath, this.dialogTitle, this.dialogDescription, false);
        if (paths != null && paths.length == 1) {
            this.setText(paths[0].toOSString());
        }
    }

    public Button getFilesystemBrowseButton(Composite parent) {
        if (this.filesystemBrowse == null) {
            this.filesystemBrowse = new Button(parent, 8);
            this.filesystemBrowse.setFont(parent.getFont());
            this.filesystemBrowse.setText(this.filesystemBrowseLabel);
            this.filesystemBrowse.setEnabled(this.isEnabled());
            this.filesystemBrowse.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectoryBrowseField.this.browseFilesystem();
                }
            });
        }
        return this.filesystemBrowse;
    }

    public Button getWorkspaceBrowseButton(Composite parent) {
        if (this.workspaceBrowse == null) {
            this.workspaceBrowse = new Button(parent, 8);
            this.workspaceBrowse.setFont(parent.getFont());
            this.workspaceBrowse.setText(this.workspaceBrowseLabel);
            this.workspaceBrowse.setEnabled(this.isEnabled());
            this.workspaceBrowse.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectoryBrowseField.this.browseWorkspace();
                }
            });
        }
        return this.workspaceBrowse;
    }

    public void setFilesystemBrowseLabel(String filesystemBrowseLabel) {
        this.filesystemBrowseLabel = filesystemBrowseLabel;
    }

    public void setWorkspaceBrowseLabel(String workspaceBrowseLabel) {
        this.workspaceBrowseLabel = workspaceBrowseLabel;
    }
}

