/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.hibernate.eclipse.graph.model.AssociationViewAdapter;

public abstract class GraphNode
extends Observable {
    public static final String ASSOCIATONS = "ASSOCIATIONS";
    private Rectangle bounds = new Rectangle(0, 0, -1, -1);
    protected List targetAssociations = new ArrayList();
    protected List sourceAssociations = null;

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        Rectangle oldBounds = this.bounds;
        if (!bounds.equals((Object)oldBounds)) {
            this.bounds = bounds;
            this.setChanged();
            this.notifyObservers();
        }
    }

    public abstract void createAssociations();

    public List getSourceAssociations() {
        this.checkAssociations();
        return this.sourceAssociations;
    }

    private void checkAssociations() {
        if (this.sourceAssociations == null) {
            this.sourceAssociations = new ArrayList();
            this.createAssociations();
        }
    }

    protected void addTargetAssociation(AssociationViewAdapter iva) {
        this.targetAssociations.add(iva);
        this.setChanged();
        this.notifyObservers(ASSOCIATONS);
    }

    protected void addSourceAssociation(AssociationViewAdapter iva) {
        this.checkAssociations();
        this.sourceAssociations.add(iva);
        this.setChanged();
        this.notifyObservers(ASSOCIATONS);
    }

    public List getTargetAssociations() {
        return this.targetAssociations;
    }
}

