/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCReaderFactory;
import org.hibernate.cfg.Settings;
import org.hibernate.cfg.reveng.DatabaseCollector;
import org.hibernate.cfg.reveng.DefaultDatabaseCollector;
import org.hibernate.cfg.reveng.JDBCReader;
import org.hibernate.cfg.reveng.ProgressListener;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.workbench.BasicWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazyDatabaseSchema;
import org.hibernate.eclipse.console.workbench.ProgressListenerMonitor;
import org.hibernate.eclipse.console.workbench.TableContainer;

public class LazyDatabaseSchemaWorkbenchAdapter
extends BasicWorkbenchAdapter {
    public Object[] getChildren(Object o) {
        return this.getChildren(o, (IProgressMonitor)new NullProgressMonitor());
    }

    public Object[] getChildren(Object o, IProgressMonitor monitor) {
        LazyDatabaseSchema dbs = this.getLazyDatabaseSchema(o);
        DefaultDatabaseCollector db = new DefaultDatabaseCollector();
        ConsoleConfiguration consoleConfiguration = dbs.getConsoleConfiguration();
        try {
            this.readDatabaseSchema(monitor, db, consoleConfiguration, dbs.getReverseEngineeringStrategy());
            ArrayList<TableContainer> result = new ArrayList<TableContainer>();
            Iterator qualifierEntries = db.getQualifierEntries();
            while (qualifierEntries.hasNext()) {
                Map.Entry entry = (Map.Entry)qualifierEntries.next();
                result.add(new TableContainer((String)entry.getKey(), (List)entry.getValue()));
            }
            return this.toArray(result.iterator(), TableContainer.class, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return ((TableContainer)arg0).getName().compareTo(((TableContainer)arg1).getName());
                }
            });
        }
        catch (HibernateException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage("Problems while reading database schema", e);
            return new Object[]{"<Reading schema error: " + e.getMessage() + ">"};
        }
    }

    private LazyDatabaseSchema getLazyDatabaseSchema(Object o) {
        return (LazyDatabaseSchema)o;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return EclipseImages.getImageDescriptor("TABLE");
    }

    public String getLabel(Object o) {
        return "Database";
    }

    public Object getParent(Object o) {
        return this.getLazyDatabaseSchema(o).getConsoleConfiguration();
    }

    protected void readDatabaseSchema(final IProgressMonitor monitor, final DefaultDatabaseCollector db, ConsoleConfiguration consoleConfiguration, final ReverseEngineeringStrategy strategy) {
        final Configuration configuration = consoleConfiguration.buildWith(null, false);
        consoleConfiguration.getExecutionContext().execute(new ExecutionContext.Command(){

            public Object execute() {
                Settings settings = configuration.buildSettings();
                ConnectionProvider connectionProvider = null;
                try {
                    try {
                        connectionProvider = settings.getConnectionProvider();
                        JDBCReader reader = JDBCReaderFactory.newJDBCReader((Properties)configuration.getProperties(), (Settings)settings, (ReverseEngineeringStrategy)strategy);
                        reader.readDatabaseSchema((DatabaseCollector)db, settings.getDefaultCatalogName(), settings.getDefaultSchemaName(), (ProgressListener)new ProgressListenerMonitor(monitor));
                    }
                    catch (HibernateException he) {
                        HibernateConsolePlugin.getDefault().logErrorMessage("Problem while reading database schema", he);
                        Object[] objectArray = new Object[]{"<Schema not available>"};
                        if (connectionProvider != null) {
                            connectionProvider.close();
                        }
                        return objectArray;
                    }
                }
                finally {
                    if (connectionProvider != null) {
                        connectionProvider.close();
                    }
                }
                return null;
            }
        });
    }
}

