/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.Iterator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class ReloadConfigurationAction
extends ConsoleConfigurationBasedAction {
    private StructuredViewer viewer;

    protected ReloadConfigurationAction(StructuredViewer sv) {
        super("Rebuild configuration");
        this.setEnabledWhenNoSessionFactory(true);
        this.viewer = sv;
        this.setImageDescriptor(EclipseImages.getImageDescriptor("images/reload.gif"));
    }

    protected void doRun() {
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            try {
                Object node = i.next();
                if (!(node instanceof ConsoleConfiguration)) continue;
                ConsoleConfiguration config = (ConsoleConfiguration)node;
                config.reset();
                this.updateState(config);
                this.viewer.refresh(node);
            }
            catch (HibernateConsoleRuntimeException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), "Exception while connecting/starting Hibernate", he);
            }
            catch (UnsupportedClassVersionError ucve) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), "Starting Hibernate resulted in a UnsupportedClassVersionError.\nThis can occur if you are running eclipse with JDK 1.4 and your domain classes require JDK 1.5. \n\nResolution: Run eclipse with JDK 1.5.", ucve);
            }
        }
    }
}

