/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.node.BaseNode;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.EditConsoleConfiguration;
import org.hibernate.eclipse.console.actions.OpenMappingAction;
import org.hibernate.eclipse.console.viewers.xpl.MTreeViewer;
import org.hibernate.eclipse.console.views.ConfigurationsViewActionGroup;
import org.hibernate.eclipse.console.views.ConsoleConfigurationPropertySourceProvider;
import org.hibernate.eclipse.console.views.KnownConfigurationsProvider;
import org.hibernate.eclipse.console.workbench.xpl.AnyAdaptableLabelProvider;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.util.StringHelper;

public class KnownConfigurationsView
extends ViewPart {
    public static final String ID = "org.hibernate.eclipse.console.views.KnownConfigurationsView";
    TreeViewer viewer;
    private ActionGroup actionGroup;
    private Action doubleAction;

    public void createPartControl(Composite parent) {
        this.viewer = new MTreeViewer(parent, 770);
        this.viewer.setLabelProvider((IBaseLabelProvider)new AnyAdaptableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new KnownConfigurationsProvider());
        this.viewer.setInput((Object)KnownConfigurations.getInstance());
        this.makeActions();
        this.createContextMenu();
        this.hookDoubleClick();
        this.provideSelection();
    }

    private void hookDoubleClick() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                KnownConfigurationsView.this.doubleAction.run();
            }
        });
    }

    private void provideSelection() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                KnownConfigurationsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager dropDownMenu = actionBars.getMenuManager();
        this.actionGroup.fillContextMenu(dropDownMenu);
        this.actionGroup.fillActionBars(actionBars);
    }

    protected void fillContextMenu(IMenuManager menuMgr) {
        this.actionGroup.setContext(new ActionContext(this.viewer.getSelection()));
        this.actionGroup.fillContextMenu(menuMgr);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.actionGroup = new ConfigurationsViewActionGroup((IViewPart)this, (StructuredViewer)this.viewer);
        this.doubleAction = new Action(){

            public void run() {
                ISelection selection = KnownConfigurationsView.this.viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof ConsoleConfiguration) {
                    new EditConsoleConfiguration((ConsoleConfiguration)firstElement).run();
                } else if (firstElement instanceof BaseNode) {
                    String hql;
                    BaseNode node = (BaseNode)firstElement;
                    ConsoleConfiguration consoleConfiguration = node.getConsoleConfiguration();
                    if (consoleConfiguration.isSessionFactoryCreated() && StringHelper.isNotEmpty((String)(hql = node.getHQL()))) {
                        consoleConfiguration.executeHQLQuery(hql);
                    }
                } else if (selection instanceof TreeSelection) {
                    TreePath path = ((TreeSelection)selection).getPaths()[0];
                    Object last = path.getLastSegment();
                    ConsoleConfiguration consoleConfiguration = (ConsoleConfiguration)path.getSegment(0);
                    if (last instanceof PersistentClass || last.getClass() == Property.class) {
                        try {
                            OpenMappingAction.run(path, consoleConfiguration);
                        }
                        catch (Exception e) {
                            HibernateConsolePlugin.getDefault().logErrorMessage("Can't find mapping file.", e);
                        }
                    }
                }
            }
        };
    }

    public void dispose() {
        super.dispose();
        this.actionGroup.dispose();
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider((IPropertySourceProvider)new ConsoleConfigurationPropertySourceProvider());
            return page;
        }
        return super.getAdapter(adapter);
    }
}

