/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.ArrayList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;

public class ConsoleConfigurationPropertySource
implements IPropertySource {
    private final ConsoleConfiguration cfg;
    static IPropertyDescriptor[] pd;

    static {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(new TextPropertyDescriptor((Object)"name", "Name"));
        l.add(new PropertyDescriptor((Object)"hibernate.cfg.xml", "Configuration file"));
        l.add(new PropertyDescriptor((Object)"hibernate.properties", "Properties file"));
        l.add(new PropertyDescriptor((Object)"mapping.files", "Additonal mapping files"));
        pd = l.toArray(new IPropertyDescriptor[l.size()]);
    }

    public ConsoleConfigurationPropertySource(ConsoleConfiguration cfg) {
        this.cfg = cfg;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return pd;
    }

    public Object getPropertyValue(Object id) {
        try {
            if ("name".equals(id)) {
                return this.cfg.getName();
            }
            ConsoleConfigurationPreferences preferences = this.cfg.getPreferences();
            if ("hibernate.cfg.xml".equals(id)) {
                return preferences.getConfigXMLFile();
            }
            if ("hibernate.properties".equals(id)) {
                return preferences.getPropertyFile();
            }
            if ("mapping.files".equals(id)) {
                return new Integer(preferences.getMappingFiles().length);
            }
            return null;
        }
        catch (RuntimeException e) {
            return "Error: " + e.getMessage();
        }
    }

    public boolean isPropertySet(Object id) {
        return true;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

