/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.properties;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.PropertyPage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.ProjectUtils;

public class HibernatePropertyPage
extends PropertyPage {
    Control[] settings;
    private Button enableHibernate;
    private Combo selectedConfiguration;

    private void addLogoSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000008, 0x1000008, true, true);
        composite.setLayoutData((Object)data);
        this.createLogoButtons(composite);
    }

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 2);
        this.enableHibernate = new Button(composite, 32);
        this.enableHibernate.setText("Enable Hibernate 3 support");
        this.enableHibernate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = HibernatePropertyPage.this.enableHibernate.getSelection();
                HibernatePropertyPage.this.enableSettings(selection);
            }
        });
    }

    private void createLogoButtons(Composite composite) {
        Button hibernateLogoButton = new Button(composite, 0);
        hibernateLogoButton.setImage(EclipseImages.getImage("images/hibernate.gif"));
        hibernateLogoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HibernatePropertyPage.this.openBrowser("http://tools.hibernate.org");
            }
        });
        Button jbossLogoButton = new Button(composite, 0);
        jbossLogoButton.setImage(EclipseImages.getImage("images/jboss.gif"));
        jbossLogoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HibernatePropertyPage.this.openBrowser("http://www.jboss.org/products/jbosside");
            }
        });
    }

    protected void openBrowser(String href) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(this.urlEncode(href.toCharArray())));
        }
        catch (MalformedURLException e) {
            this.openWebBrowserError(href, e);
        }
        catch (PartInitException e) {
            this.openWebBrowserError(href, e);
        }
    }

    private void openWebBrowserError(final String href, final Throwable t) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                String title = "Open URL";
                String msg = "Unable to open webbrowser for url: " + href;
                IStatus status = HibernateConsolePlugin.throwableToStatus(t);
                ErrorDialog.openError((Shell)HibernatePropertyPage.this.getShell(), (String)title, (String)msg, (IStatus)status);
            }
        });
    }

    private String urlEncode(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite settingsPart = this.createDefaultComposite(parent, 2);
        Label ownerLabel = new Label(settingsPart, 0);
        ownerLabel.setText("Default Hibernate Console configuration:");
        this.selectedConfiguration = new Combo(parent, 4);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.selectedConfiguration.setLayoutData((Object)gd);
        ConsoleConfiguration[] configurations = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        int i = 0;
        while (i < configurations.length) {
            ConsoleConfiguration configuration = configurations[i];
            this.selectedConfiguration.add(configuration.getName());
            ++i;
        }
        this.settings = new Control[]{ownerLabel, this.selectedConfiguration};
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        this.addSeparator(composite);
        this.addLogoSection(composite);
        this.loadValues();
        this.enableSettings(this.enableHibernate.getSelection());
        return composite;
    }

    private Composite createDefaultComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.enableHibernate.setSelection(false);
        this.selectedConfiguration.setText("");
    }

    private IProject getProject() {
        IJavaElement elem;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null && (elem = (IJavaElement)adaptable.getAdapter(IJavaElement.class)) instanceof IJavaProject) {
            return ((IJavaProject)elem).getProject();
        }
        return null;
    }

    public void loadValues() {
        IProject project = this.getProject();
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            this.enableHibernate.setSelection(node.getBoolean("hibernate3.enabled", false));
            String cfg = node.get("default.configuration", project.getName());
            ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(cfg);
            if (configuration == null) {
                this.selectedConfiguration.setText("");
            } else {
                this.selectedConfiguration.setText(cfg);
            }
        }
    }

    public boolean performOk() {
        ProjectUtils.toggleHibernateOnProject(this.getProject(), this.enableHibernate.getSelection(), this.selectedConfiguration.getText());
        return true;
    }

    private void enableSettings(boolean selection) {
        int i = 0;
        while (i < this.settings.length) {
            Control comp = this.settings[i];
            comp.setEnabled(selection);
            ++i;
        }
    }
}

