/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;

public abstract class OpenQueryEditorAction
extends SelectionListenerAction {
    protected OpenQueryEditorAction(String text) {
        super(text);
    }

    public void runWithEvent(Event event) {
        boolean showed = false;
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel instanceof TreeSelection) {
            TreePath[] paths = ((TreeSelection)sel).getPaths();
            showed = this.doRun(paths);
        }
        if (!showed) {
            this.openQueryEditor(null, "");
        }
    }

    protected boolean doRun(TreePath[] paths) {
        boolean showed = false;
        int i = 0;
        while (i < paths.length) {
            TreePath path = paths[i];
            ConsoleConfiguration config = (ConsoleConfiguration)path.getSegment(0);
            try {
                this.openQueryEditor(config, this.generateQuery(path));
                showed = true;
            }
            catch (HibernateException he) {
                HibernateConsolePlugin.getDefault().showError(null, "Exception while trying to open HQL editor", he);
            }
            ++i;
        }
        return showed;
    }

    protected abstract void openQueryEditor(ConsoleConfiguration var1, String var2);

    protected abstract String generateQuery(TreePath var1);
}

