/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.OpenFileActionUtils;
import org.hibernate.eclipse.console.actions.OpenSourceAction;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.tool.hbm2x.Cfg2HbmTool;

public class OpenMappingAction
extends SelectionListenerAction {
    private static final String HIBERNATE_TAG_NAME = "name";
    private static final String HIBERNATE_TAG_ENTITY_NAME = "entity-name";
    private String imageFilePath = "icons/images/mapping.gif";

    public OpenMappingAction() {
        super("Open Mapping File");
        this.setToolTipText("Open Mapping File");
        this.setEnabled(true);
        this.setImageDescriptor(HibernateConsolePlugin.getImageDescriptor(this.imageFilePath));
    }

    public void run() {
        IStructuredSelection sel = this.getStructuredSelection();
        if (sel instanceof TreeSelection) {
            int i = 0;
            while (i < ((TreeSelection)sel).getPaths().length) {
                TreePath path = ((TreeSelection)sel).getPaths()[i];
                ConsoleConfiguration consoleConfiguration = (ConsoleConfiguration)path.getSegment(0);
                try {
                    OpenMappingAction.run(path, consoleConfiguration);
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't find mapping file.", e);
                }
                catch (PartInitException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't open mapping file.", e);
                }
                catch (FileNotFoundException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Can't find mapping file.", e);
                }
                ++i;
            }
        }
    }

    public static void run(TreePath path, ConsoleConfiguration consoleConfiguration) throws PartInitException, JavaModelException, FileNotFoundException {
        Property propertySel;
        PersistentClass persClass;
        boolean isPropertySel;
        boolean bl = isPropertySel = path.getLastSegment().getClass() == Property.class;
        if (isPropertySel && ((persClass = (propertySel = (Property)path.getLastSegment()).getPersistentClass()) == null || RootClass.class.isAssignableFrom(persClass.getClass()) && persClass.getClass() != RootClass.class)) {
            Property parentProp = (Property)path.getParentPath().getLastSegment();
            OpenMappingAction.run(propertySel, parentProp, consoleConfiguration);
            return;
        }
        OpenMappingAction.run(path.getLastSegment(), consoleConfiguration);
    }

    public static IEditorPart run(Object selection, ConsoleConfiguration consoleConfiguration) throws PartInitException, JavaModelException, FileNotFoundException {
        IEditorPart editorPart = null;
        IJavaProject proj = ProjectUtils.findJavaProject(consoleConfiguration);
        File configXMLFile = consoleConfiguration.getPreferences().getConfigXMLFile();
        if (configXMLFile == null) {
            return null;
        }
        IResource resource = null;
        if (selection instanceof Property) {
            Property p = (Property)selection;
            if (p.getPersistentClass() == null) {
                return null;
            }
            resource = OpenFileActionUtils.getResource(consoleConfiguration, proj, configXMLFile, p.getPersistentClass());
        } else {
            resource = OpenFileActionUtils.getResource(consoleConfiguration, proj, configXMLFile, selection);
        }
        if (resource != null) {
            editorPart = OpenMappingAction.openMapping(resource);
            if (editorPart != null) {
                OpenMappingAction.applySelectionToEditor(selection, editorPart);
            }
            return editorPart;
        }
        PersistentClass rootClass = null;
        if (selection instanceof PersistentClass) {
            rootClass = (PersistentClass)selection;
        } else if (selection instanceof Property) {
            Property p = (Property)selection;
            if (p.getPersistentClass() == null) {
                return null;
            }
            rootClass = p.getPersistentClass();
        }
        if (rootClass != null) {
            if (OpenFileActionUtils.rootClassHasAnnotations(consoleConfiguration, configXMLFile, rootClass)) {
                String fullyQualifiedName = rootClass.getClassName();
                editorPart = new OpenSourceAction().run(selection, proj, fullyQualifiedName);
                return editorPart;
            }
        } else {
            throw new FileNotFoundException("Mapping for " + selection + " not found.");
        }
        return null;
    }

    public static IEditorPart run(Property compositeProperty, Property parentProperty, ConsoleConfiguration consoleConfiguration) throws PartInitException, JavaModelException, FileNotFoundException {
        PersistentClass rootClass;
        if (parentProperty.getPersistentClass() == null) {
            return null;
        }
        IJavaProject proj = ProjectUtils.findJavaProject(consoleConfiguration);
        File configXMLFile = consoleConfiguration.getPreferences().getConfigXMLFile();
        if (configXMLFile == null) {
            return null;
        }
        IResource resource = OpenFileActionUtils.getResource(consoleConfiguration, proj, configXMLFile, parentProperty.getPersistentClass());
        IEditorPart editorPart = null;
        if (resource != null) {
            editorPart = OpenMappingAction.openMapping(resource);
            if (editorPart != null) {
                ITextEditor[] textEditors = OpenMappingAction.getTextEditors(editorPart);
                if (textEditors.length == 0) {
                    return editorPart;
                }
                textEditors[0].selectAndReveal(0, 0);
                FindReplaceDocumentAdapter findAdapter = null;
                ITextEditor textEditor = null;
                int i = 0;
                while (i < textEditors.length && findAdapter == null) {
                    textEditor = textEditors[i];
                    findAdapter = OpenMappingAction.getFindDocAdapter(textEditor);
                    ++i;
                }
                if (findAdapter == null) {
                    return null;
                }
                IRegion parentRegion = OpenMappingAction.findSelection(parentProperty, findAdapter);
                if (parentRegion == null) {
                    return editorPart;
                }
                IRegion propRegion = null;
                try {
                    propRegion = findAdapter.find(parentRegion.getOffset() + parentRegion.getLength(), OpenMappingAction.generatePattern(compositeProperty), true, true, false, true);
                    if (propRegion == null) {
                        String pattern = OpenMappingAction.generatePattern(compositeProperty).replaceFirst("property", "key-property");
                        propRegion = findAdapter.find(parentRegion.getOffset() + parentRegion.getLength(), pattern, true, true, false, true);
                    }
                }
                catch (BadLocationException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Selection not found.", e);
                }
                if (propRegion != null) {
                    int length = compositeProperty.getNodeName().length();
                    int offset = propRegion.getOffset() + propRegion.getLength() - length - 1;
                    propRegion = new Region(offset, length);
                    textEditor.selectAndReveal(propRegion.getOffset(), propRegion.getLength());
                    return editorPart;
                }
            }
            return editorPart;
        }
        if (parentProperty.getPersistentClass() != null && parentProperty.isComposite() && OpenFileActionUtils.rootClassHasAnnotations(consoleConfiguration, configXMLFile, rootClass = parentProperty.getPersistentClass())) {
            String fullyQualifiedName = ((Component)parentProperty.getValue()).getComponentClassName();
            IEditorPart editor = new OpenSourceAction().run(compositeProperty, proj, fullyQualifiedName);
            return editor;
        }
        if (editorPart == null) {
            throw new FileNotFoundException("Mapping file for property '" + compositeProperty.getNodeName() + "' not found.");
        }
        return null;
    }

    public static boolean applySelectionToEditor(Object selection, IEditorPart editorPart) {
        ITextEditor[] textEditors = OpenMappingAction.getTextEditors(editorPart);
        if (textEditors.length == 0) {
            return false;
        }
        textEditors[0].selectAndReveal(0, 0);
        FindReplaceDocumentAdapter findAdapter = null;
        ITextEditor textEditor = null;
        int i = 0;
        while (i < textEditors.length && findAdapter == null) {
            textEditor = textEditors[i];
            findAdapter = OpenMappingAction.getFindDocAdapter(textEditor);
            ++i;
        }
        if (findAdapter == null) {
            return false;
        }
        IRegion selectRegion = null;
        if (selection instanceof RootClass || selection instanceof Subclass) {
            selectRegion = OpenMappingAction.findSelection((PersistentClass)selection, findAdapter);
        } else if (selection instanceof Property) {
            selectRegion = OpenMappingAction.findSelection((Property)selection, findAdapter);
        }
        if (selectRegion != null) {
            textEditor.selectAndReveal(selectRegion.getOffset(), selectRegion.getLength());
            return true;
        }
        return false;
    }

    private static FindReplaceDocumentAdapter getFindDocAdapter(ITextEditor textEditor) {
        IDocument document = null;
        if (textEditor.getDocumentProvider() != null) {
            document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        }
        if (document == null) {
            return null;
        }
        FindReplaceDocumentAdapter findAdapter = new FindReplaceDocumentAdapter(document);
        return findAdapter;
    }

    public static IEditorPart openMapping(IResource resource) {
        if (resource != null && resource instanceof IFile) {
            try {
                HibernateConsolePlugin.getDefault();
                return OpenFileActionUtils.openEditor(HibernateConsolePlugin.getActiveWorkbenchWindow().getActivePage(), (IResource)((IFile)resource));
            }
            catch (PartInitException partInitException) {}
        } else {
            HibernateConsolePlugin.getDefault().log("Can't open mapping file " + resource);
        }
        return null;
    }

    public static IRegion findSelection(Property property, FindReplaceDocumentAdapter findAdapter) {
        IRegion propRegion;
        block7: {
            IRegion finalRegion;
            block6: {
                IRegion classRegion;
                block5: {
                    Assert.isNotNull((Object)property.getPersistentClass());
                    try {
                        classRegion = OpenMappingAction.findSelection(property.getPersistentClass(), findAdapter);
                        if (classRegion != null) break block5;
                        return null;
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                finalRegion = findAdapter.find(classRegion.getOffset() + classRegion.getLength(), "</class", true, true, false, false);
                propRegion = findAdapter.find(classRegion.getOffset() + classRegion.getLength(), OpenMappingAction.generatePattern(property), true, true, false, true);
                if (propRegion != null) break block6;
                return null;
            }
            if (finalRegion == null || propRegion.getOffset() <= finalRegion.getOffset()) break block7;
            return null;
        }
        int length = property.getName().length();
        int offset = propRegion.getOffset() + propRegion.getLength() - length - 1;
        return new Region(offset, length);
    }

    public static IRegion findSelection(PersistentClass persClass, FindReplaceDocumentAdapter findAdapter) {
        IRegion classRegion;
        block4: {
            try {
                String[] classPatterns = OpenMappingAction.generatePatterns(persClass);
                classRegion = null;
                int i = 0;
                while (classRegion == null && i < classPatterns.length) {
                    classRegion = findAdapter.find(0, classPatterns[i], true, true, false, true);
                    ++i;
                }
                if (classRegion != null) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int length = persClass.getNodeName().length();
        int offset = classRegion.getOffset() + classRegion.getLength() - length - 1;
        return new Region(offset, length);
    }

    private static String[] generatePatterns(PersistentClass persClass) {
        String fullClassName = null;
        String shortClassName = null;
        fullClassName = persClass.getEntityName() != null ? persClass.getEntityName() : persClass.getClassName();
        shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        Cfg2HbmTool tool = new Cfg2HbmTool();
        String[] patterns = new String[4];
        StringBuffer pattern = new StringBuffer("<");
        pattern.append(tool.getTag(persClass));
        pattern.append("[\\s]+[.[^>]]*");
        pattern.append(HIBERNATE_TAG_NAME);
        pattern.append("[\\s]*=[\\s]*\"");
        pattern.append(shortClassName);
        pattern.append('\"');
        patterns[0] = pattern.toString();
        pattern = new StringBuffer("<");
        pattern.append(tool.getTag(persClass));
        pattern.append("[\\s]+[.[^>]]*");
        pattern.append(HIBERNATE_TAG_NAME);
        pattern.append("[\\s]*=[\\s]*\"");
        pattern.append(fullClassName);
        pattern.append('\"');
        patterns[1] = pattern.toString();
        pattern = new StringBuffer("<");
        pattern.append(tool.getTag(persClass));
        pattern.append("[\\s]+[.[^>]]*");
        pattern.append(HIBERNATE_TAG_ENTITY_NAME);
        pattern.append("[\\s]*=[\\s]*\"");
        pattern.append(shortClassName);
        pattern.append('\"');
        patterns[2] = pattern.toString();
        pattern = new StringBuffer("<");
        pattern.append(tool.getTag(persClass));
        pattern.append("[\\s]+[.[^>]]*");
        pattern.append(HIBERNATE_TAG_ENTITY_NAME);
        pattern.append("[\\s]*=[\\s]*\"");
        pattern.append(fullClassName);
        pattern.append('\"');
        patterns[3] = pattern.toString();
        return patterns;
    }

    private static String generatePattern(Property property) {
        Cfg2HbmTool tool = new Cfg2HbmTool();
        StringBuffer pattern = new StringBuffer("<");
        if (property.getPersistentClass() != null && property.getPersistentClass().getIdentifierProperty() == property) {
            if (property.isComposite()) {
                pattern.append("composite-id");
            } else {
                pattern.append("id");
            }
        } else {
            pattern.append(tool.getTag(property));
        }
        pattern.append("[\\s]+[.[^>]]*");
        pattern.append(HIBERNATE_TAG_NAME);
        pattern.append("[\\s]*=[\\s]*\"");
        pattern.append(property.getNodeName());
        pattern.append('\"');
        return pattern.toString();
    }

    public static ITextEditor[] getTextEditors(IEditorPart editorPart) {
        if (editorPart instanceof MultiPageEditorPart) {
            ArrayList<IEditorPart> testEditors = new ArrayList<IEditorPart>();
            IEditorPart[] editors = ((MultiPageEditorPart)editorPart).findEditors(editorPart.getEditorInput());
            int i = 0;
            while (i < editors.length) {
                if (editors[i] instanceof ITextEditor) {
                    testEditors.add(editors[i]);
                }
                ++i;
            }
            return testEditors.toArray(new ITextEditor[0]);
        }
        if (editorPart instanceof ITextEditor) {
            return new ITextEditor[]{(ITextEditor)editorPart};
        }
        return new ITextEditor[0];
    }
}

