/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.util.StringHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.InputSource;

public class OpenFileActionUtils {
    private static XMLHelper helper = new XMLHelper();
    private static final String HIBERNATE_TAG_CLASS = "class";
    private static final String HIBERNATE_TAG_TABLE = "table";
    private static final String HIBERNATE_TAG_SUBCLASS = "subclass";
    private static final String HIBERNATE_TAG_JOINED_SUBCLASS = "joined-subclass";
    private static final String HIBERNATE_TAG_UNION_SUBCLASS = "union-subclass";
    private static final String HIBERNATE_TAG_NAME = "name";
    private static final String HIBERNATE_TAG_ENTITY_NAME = "entity-name";
    private static final String HIBERNATE_TAG_SESSION_FACTORY = "session-factory";
    private static final String HIBERNATE_TAG_MAPPING = "mapping";
    private static final String HIBERNATE_TAG_RESOURCE = "resource";
    private static final String HIBERNATE_TAG_CATALOG = "catalog";
    private static final String HIBERNATE_TAG_SCHEMA = "schema";

    public static IEditorPart openEditor(IWorkbenchPage page, IResource resource) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource));
    }

    public static boolean rootClassHasAnnotations(ConsoleConfiguration consoleConfiguration, File configXMLFile, PersistentClass rootClass) {
        if (configXMLFile == null) {
            return true;
        }
        Document doc = OpenFileActionUtils.getDocument(consoleConfiguration, configXMLFile);
        return OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_MAPPING, HIBERNATE_TAG_CLASS, OpenFileActionUtils.getPersistentClassName(rootClass)).hasNext();
    }

    static String getPersistentClassName(PersistentClass rootClass) {
        if (rootClass == null) {
            return "";
        }
        return rootClass.getEntityName() != null ? rootClass.getEntityName() : rootClass.getClassName();
    }

    private static String getTableName(String catalog, String schema, String name) {
        return String.valueOf(catalog != null ? String.valueOf(catalog) + '.' : "") + (schema != null ? String.valueOf(schema) + '.' : "") + name;
    }

    private static String getTableName(Table table) {
        return OpenFileActionUtils.getTableName(table.getCatalog(), table.getSchema(), table.getName());
    }

    private static boolean elementInResource(ConsoleConfiguration consoleConfiguration, IResource resource, Object element) {
        if (element instanceof RootClass) {
            return OpenFileActionUtils.rootClassInResource(consoleConfiguration, resource, (RootClass)element);
        }
        if (element instanceof Subclass) {
            return OpenFileActionUtils.subclassInResource(consoleConfiguration, resource, (Subclass)element);
        }
        if (element instanceof Table) {
            return OpenFileActionUtils.tableInResource(consoleConfiguration, resource, (Table)element);
        }
        return false;
    }

    private static boolean rootClassInResource(ConsoleConfiguration consoleConfiguration, IResource resource, RootClass persistentClass) {
        Document doc = OpenFileActionUtils.getDocument(consoleConfiguration, resource.getLocation().toFile());
        return OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_CLASS, HIBERNATE_TAG_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_CLASS, HIBERNATE_TAG_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_CLASS, HIBERNATE_TAG_ENTITY_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_CLASS, HIBERNATE_TAG_ENTITY_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext();
    }

    private static boolean subclassInResource(ConsoleConfiguration consoleConfiguration, IResource resource, Subclass persistentClass) {
        Document doc = OpenFileActionUtils.getDocument(consoleConfiguration, resource.getLocation().toFile());
        return OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_SUBCLASS, HIBERNATE_TAG_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_SUBCLASS, HIBERNATE_TAG_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_SUBCLASS, HIBERNATE_TAG_ENTITY_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_SUBCLASS, HIBERNATE_TAG_ENTITY_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_JOINED_SUBCLASS, HIBERNATE_TAG_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_JOINED_SUBCLASS, HIBERNATE_TAG_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_JOINED_SUBCLASS, HIBERNATE_TAG_ENTITY_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_JOINED_SUBCLASS, HIBERNATE_TAG_ENTITY_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_UNION_SUBCLASS, HIBERNATE_TAG_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_UNION_SUBCLASS, HIBERNATE_TAG_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_UNION_SUBCLASS, HIBERNATE_TAG_ENTITY_NAME, StringHelper.unqualify((String)OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass))).hasNext() || OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_UNION_SUBCLASS, HIBERNATE_TAG_ENTITY_NAME, OpenFileActionUtils.getPersistentClassName((PersistentClass)persistentClass)).hasNext();
    }

    private static boolean tableInResource(ConsoleConfiguration consoleConfiguration, IResource resource, Table table) {
        Document doc = OpenFileActionUtils.getDocument(consoleConfiguration, resource.getLocation().toFile());
        Iterator classes = OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_CLASS);
        while (classes.hasNext()) {
            Attribute classNameAttr;
            Element element = (Element)classes.next();
            Attribute tableAttr = element.attribute(HIBERNATE_TAG_TABLE);
            if (tableAttr != null) {
                Attribute schemaAttr;
                Attribute catalogAttr = element.attribute(HIBERNATE_TAG_CATALOG);
                if (catalogAttr == null) {
                    catalogAttr = doc.getRootElement().attribute(HIBERNATE_TAG_CATALOG);
                }
                if ((schemaAttr = element.attribute(HIBERNATE_TAG_SCHEMA)) == null) {
                    schemaAttr = doc.getRootElement().attribute(HIBERNATE_TAG_SCHEMA);
                }
                if (OpenFileActionUtils.getTableName(catalogAttr != null ? catalogAttr.getValue() : null, schemaAttr != null ? schemaAttr.getValue() : null, tableAttr.getValue()).equals(OpenFileActionUtils.getTableName(table))) {
                    return true;
                }
            }
            if ((classNameAttr = element.attribute(HIBERNATE_TAG_NAME)) == null) {
                classNameAttr = element.attribute(HIBERNATE_TAG_ENTITY_NAME);
            }
            if (classNameAttr == null) continue;
            String physicalTableName = consoleConfiguration.getConfiguration().getNamingStrategy().classToTableName(classNameAttr.getValue());
            if (!table.getName().equals(physicalTableName)) continue;
            return true;
        }
        return OpenFileActionUtils.getElements(doc, HIBERNATE_TAG_TABLE, table.getName()).hasNext();
    }

    private static Iterator getElements(Document doc, String elementName) {
        return OpenFileActionUtils.getElements(doc, elementName, null, null);
    }

    private static Iterator getElements(Document doc, String attrName, String attrValue) {
        return OpenFileActionUtils.getElements(doc, null, attrName, attrValue);
    }

    private static Iterator getElements(Document doc, String elementName, String attrName, String attrValue) {
        LVS visitor = new LVS(elementName, attrName, attrValue);
        doc.accept((Visitor)visitor);
        return visitor.iterator();
    }

    private static boolean attrIsCorrect(Element element, String attrName, String attrValue) {
        Attribute attr = element.attribute(attrName);
        if (attr != null && attrValue.equals(attr.getValue())) {
            return attrValue.equals(attr.getValue());
        }
        return false;
    }

    public static Document getDocument(ConsoleConfiguration consoleConfiguration, File configXMLFile) {
        Document doc = null;
        if (consoleConfiguration != null && configXMLFile != null) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(configXMLFile);
            }
            catch (FileNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Configuration file not found", e);
            }
            try {
                try {
                    ArrayList errors = new ArrayList();
                    doc = helper.createSAXReader(configXMLFile.getPath(), errors, consoleConfiguration.getConfiguration().getEntityResolver()).read(new InputSource(stream));
                    if (errors.size() != 0) {
                        HibernateConsolePlugin.getDefault().logErrorMessage("invalid configuration", (Throwable)null);
                    }
                }
                catch (DocumentException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Could not parse configuration", e);
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException ioe) {
                        HibernateConsolePlugin.getDefault().logErrorMessage("could not close input stream for", ioe);
                    }
                }
            }
            finally {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException ioe) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("could not close input stream for", ioe);
                }
            }
        }
        return doc;
    }

    public static IResource getResource(ConsoleConfiguration consoleConfiguration, IJavaProject proj, File configXMLFile, Object element) {
        Document doc = OpenFileActionUtils.getDocument(consoleConfiguration, configXMLFile);
        IFile resource = null;
        if (consoleConfiguration != null && proj != null && doc != null) {
            Element sfNode = doc.getRootElement().element(HIBERNATE_TAG_SESSION_FACTORY);
            for (Element subelement : sfNode.elements(HIBERNATE_TAG_MAPPING)) {
                Attribute file = subelement.attribute(HIBERNATE_TAG_RESOURCE);
                if (file == null) continue;
                try {
                    IPackageFragmentRoot[] packageFragmentRoots = proj.getAllPackageFragmentRoots();
                    int i = 0;
                    while (i < packageFragmentRoots.length && resource == null) {
                        if (packageFragmentRoots[i].getClass() == PackageFragmentRoot.class) {
                            IPackageFragmentRoot packageFragmentRoot = packageFragmentRoots[i];
                            IPath path = packageFragmentRoot.getPath().append(file.getValue());
                            resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        }
                        ++i;
                    }
                    if (resource != null && OpenFileActionUtils.elementInResource(consoleConfiguration, (IResource)resource, element)) {
                        return resource;
                    }
                    resource = null;
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().logErrorMessage("Problems while getting project package fragment roots", e);
                }
            }
            File[] files = consoleConfiguration.getPreferences().getMappingFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file != null && (resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getPath()))) != null && OpenFileActionUtils.elementInResource(consoleConfiguration, (IResource)resource, element)) {
                    return resource;
                }
                ++i;
            }
        }
        return null;
    }

    static class LVS
    extends VisitorSupport {
        private String nodeName;
        private String attrName;
        private String attrValue;
        private List ret = new ArrayList();

        public LVS(String nodeName, String attrName, String attrValue) {
            this.nodeName = nodeName;
            this.attrName = attrName;
            this.attrValue = attrValue;
        }

        public void visit(Element element) {
            if (this.nodeName == null) {
                if (this.attrName != null && this.attrValue != null && OpenFileActionUtils.attrIsCorrect(element, this.attrName, this.attrValue)) {
                    this.ret.add(element);
                }
            } else if (this.nodeName.equals(element.getName())) {
                if (this.attrName != null) {
                    if (OpenFileActionUtils.attrIsCorrect(element, this.attrName, this.attrValue)) {
                        this.ret.add(element);
                    }
                } else {
                    this.ret.add(element);
                }
            }
        }

        public Iterator iterator() {
            return this.ret.iterator();
        }
    }
}

