/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Event;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.QueryEditor;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class ExecuteQueryAction
extends Action {
    private QueryEditor editor;

    public ExecuteQueryAction() {
        this.setImageDescriptor(EclipseImages.getImageDescriptor("EXECUTE"));
        this.initTextAndToolTip();
    }

    public ExecuteQueryAction(QueryEditor editor) {
        this();
        this.setHibernateQueryEditor(editor);
    }

    public void run() {
        this.execute(this.editor);
    }

    public void runWithEvent(Event event) {
        super.runWithEvent(event);
    }

    protected void execute(QueryEditor queryEditor) {
        try {
            ConsoleConfiguration cfg = queryEditor.getConsoleConfiguration();
            if (cfg != null) {
                if (!cfg.isSessionFactoryCreated()) {
                    if (queryEditor.askUserForConfiguration(cfg.getName())) {
                        if (cfg.getConfiguration() == null) {
                            cfg.build();
                        }
                        cfg.buildSessionFactory();
                        queryEditor.executeQuery(cfg);
                    }
                } else {
                    queryEditor.executeQuery(cfg);
                }
            }
        }
        finally {
            this.initTextAndToolTip();
        }
    }

    private void initTextAndToolTip() {
        this.setText("Run HQL");
        this.setToolTipText("Run HQL");
    }

    public void run(IAction action) {
        this.run();
    }

    public void setHibernateQueryEditor(QueryEditor editor) {
        this.editor = editor;
    }
}

