/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hibernate.HibernateException;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;

public class EditConsoleConfiguration
extends ConsoleConfigurationBasedAction {
    ConsoleConfiguration cfg = null;

    public EditConsoleConfiguration() {
        super("Edit Configuration");
    }

    public EditConsoleConfiguration(ConsoleConfiguration configuration) {
        this();
        this.cfg = configuration;
    }

    protected void doRun() {
        if (this.cfg == null) {
            Iterator i = this.getSelectedNonResources().iterator();
            while (i.hasNext()) {
                try {
                    Object node = i.next();
                    if (!(node instanceof ConsoleConfiguration)) continue;
                    ConsoleConfiguration config = (ConsoleConfiguration)node;
                    this.edit(config);
                }
                catch (HibernateException he) {
                    HibernateConsolePlugin.getDefault().showError(null, "Exception while trying to edit configuration", he);
                }
            }
        } else {
            try {
                this.edit(this.cfg);
            }
            catch (HibernateException he) {
                HibernateConsolePlugin.getDefault().showError(null, "Exception while trying to edit configuration", he);
            }
        }
    }

    private void edit(ConsoleConfiguration config) {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.hibernate.eclipse.launch.ConsoleConfigurationLaunchConfigurationType");
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchConfigurationType);
            int i = 0;
            while (i < launchConfigurations.length) {
                ILaunchConfiguration launchConfiguration = launchConfigurations[i];
                if (launchConfiguration.getName().equals(config.getName())) {
                    DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)win.getShell(), (ILaunchConfiguration)launchConfiguration, (String)"org.eclipse.debug.ui.launchGroup.run");
                    return;
                }
                ++i;
            }
            HibernateConsolePlugin.getDefault().showError(win.getShell(), "Could not find launch configuration for '" + config.getName() + "'", new IllegalStateException("No launch configuration matched the configuration named " + config.getName()));
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(win.getShell(), "Problem adding a console configuration", ce);
        }
    }

    protected boolean updateState(ConsoleConfiguration consoleConfiguration) {
        return true;
    }
}

