/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;

public class DeleteConfigurationAction
extends SelectionListenerAction {
    private StructuredViewer part;

    public DeleteConfigurationAction(StructuredViewer selectionProvider) {
        super("Delete Configuration");
        this.setEnabled(false);
        this.part = selectionProvider;
    }

    public void run() {
        List selectedNonResources = this.getSelectedNonResources();
        String question = "Do you wish to delete the selected console configuration";
        String title = "Delete console configuration";
        if (selectedNonResources.size() > 1) {
            question = String.valueOf(question) + "s";
            title = String.valueOf(title) + "s";
        }
        if (MessageDialog.openConfirm(null, (String)title, (String)(question = String.valueOf(question) + "?"))) {
            for (ConsoleConfiguration element : selectedNonResources) {
                KnownConfigurations.getInstance().removeConfiguration(element, false);
            }
            this.part.refresh();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object element : this.getSelectedNonResources()) {
                if (!(element instanceof ConsoleConfiguration)) continue;
                return true;
            }
        }
        return false;
    }
}

