/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryPage;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class CloseQueryPageAction
extends SelectionListenerAction {
    private final ISelectionProvider selectionProvider;

    public CloseQueryPageAction(ISelectionProvider selectionProvider) {
        super("");
        this.selectionProvider = selectionProvider;
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setEnabled(!this.selectionProvider.getSelection().isEmpty());
        this.setImageDescriptor(EclipseImages.getImageDescriptor("CLOSE"));
        this.setDisabledImageDescriptor(EclipseImages.getImageDescriptor("CLOSE_DISABLED"));
        this.setToolTipText("Close query page");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        if (!selection.isEmpty()) {
            Iterator i = selection.iterator();
            while (i.hasNext()) {
                KnownConfigurations.getInstance().getQueryPageModel().remove((QueryPage)i.next());
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return !selection.isEmpty();
    }
}

