/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.ConsoleConfigurationBasedAction;

public class BuildSessionFactoryAction
extends ConsoleConfigurationBasedAction {
    private final StructuredViewer viewer;

    public BuildSessionFactoryAction(StructuredViewer viewer) {
        super("Build SessionFactory");
        this.viewer = viewer;
        this.setEnabledWhenNoSessionFactory(true);
    }

    protected void doRun() {
        Iterator i = this.getSelectedNonResources().iterator();
        while (i.hasNext()) {
            try {
                Object node = i.next();
                if (!(node instanceof ConsoleConfiguration)) continue;
                ConsoleConfiguration config = (ConsoleConfiguration)node;
                if (config.isSessionFactoryCreated()) {
                    config.reset();
                } else {
                    config.build();
                    config.buildSessionFactory();
                }
                this.updateState(config);
            }
            catch (HibernateConsoleRuntimeException he) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), "Exception while connecting/starting Hibernate", he);
            }
            catch (UnsupportedClassVersionError ucve) {
                HibernateConsolePlugin.getDefault().showError(this.viewer.getControl().getShell(), "Starting Hibernate resulted in a UnsupportedClassVersionError.\nThis can occur if you are running eclipse with JDK 1.4 and your domain classes require JDK 1.5. \n\nResolution: Run eclipse with JDK 1.5.", ucve);
            }
        }
    }

    protected boolean updateState(ConsoleConfiguration config) {
        this.setEnabledWhenNoSessionFactory(!config.isSessionFactoryCreated());
        if (this.enabledWhenNoSessionFactory) {
            this.setText("Create SessionFactory");
        } else {
            this.setText("Close SessionFactory");
        }
        return super.updateState(config);
    }
}

