/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.hibernate.eclipse.mapper.editors.ReverseEngineeringEditor;
import org.hibernate.eclipse.mapper.editors.reveng.ConsoleConfigNamePart;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngFormEditorPart;

public class RevEngOverviewPage
extends RevEngFormEditorPart {
    public static final String PART_ID = "overview";
    private final ReverseEngineeringEditor reditor;
    private ConsoleConfigNamePart configNamePart;

    public RevEngOverviewPage(ReverseEngineeringEditor reditor) {
        super(reditor, PART_ID, "Overview");
        this.reditor = reditor;
    }

    public void createFormContent(IManagedForm parent) {
        ScrolledForm form = parent.getForm();
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 2;
        form.getBody().setLayout((Layout)layout);
        this.createConsoleConfigName();
        this.createContentsSection();
        this.getManagedForm().setInput((Object)this.reditor.getReverseEngineeringDefinition());
    }

    private void createConsoleConfigName() {
        Composite parent = this.getManagedForm().getForm().getBody();
        this.configNamePart = new ConsoleConfigNamePart(parent, this.getManagedForm(), this.reditor);
        this.getManagedForm().addPart((IFormPart)this.configNamePart);
    }

    private Section createStaticSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 4;
        section.setText(text);
        return section;
    }

    private void createContentsSection() {
        String sectionTitle = "Contents";
        Section section = this.createStaticSection(this.getManagedForm().getToolkit(), this.getManagedForm().getForm().getBody(), sectionTitle);
        Composite container = this.getManagedForm().getToolkit().createComposite((Composite)section, 0);
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 0;
        layout.topMargin = 0;
        layout.rightMargin = 0;
        layout.leftMargin = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new TableWrapData(256));
        this.createClient(container, "<form><p>The content of the reveng.xml is made up of three sections:</p><li style=\"image\" value=\"page\" bindent=\"5\"><a href=\"typemappings\">Type Mappings</a>: lists the mappings from a JDBC/SQL type to Hibernate type.</li><li style=\"image\" value=\"page\" bindent=\"5\"><a href=\"tablefilter\">Table filters</a>: lists which tables that should be included or excluded during reverse engineering.</li><li style=\"image\" value=\"page\" bindent=\"5\"><a href=\"tables\">Tables &amp; Columns</a>: explicitly set properties for tables and columns.</li></form>", this.getManagedForm().getToolkit());
        section.setClient((Control)container);
    }

    private FormText createClient(Composite section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        section.setLayoutData((Object)new TableWrapData(256));
        text.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String href = (String)e.getHref();
                RevEngOverviewPage.this.getEditor().setActivePage(href);
            }
        });
        return text;
    }

    protected ReverseEngineeringEditor getRevEngEditor() {
        return this.reditor;
    }

    public String getConsoleConfigName() {
        return this.configNamePart.getConsoleConfigName();
    }

    public void setConsoleConfigName(String name) {
        this.configNamePart.setConsoleConfigName(name);
    }
}

