/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors.reveng;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.hibernate.eclipse.console.model.IRevEngGenerator;
import org.hibernate.eclipse.mapper.editors.reveng.FormTextEntryListenerAdapter;
import org.hibernate.eclipse.mapper.editors.reveng.RevEngDetailsPage;
import org.hibernate.eclipse.mapper.editors.reveng.xpl.FormTextEntry;

public class GeneratorDetailsPage
extends RevEngDetailsPage
implements IDetailsPage,
PropertyChangeListener {
    private FormTextEntry nameEntry;
    private IRevEngGenerator generator;

    protected void buildContents(FormToolkit toolkit, Section section, Composite client) {
        section.setText("Id Generator details");
        section.setDescription("Set the properties of the selected generator.");
        this.nameEntry = new FormTextEntry(client, toolkit, "Class:", 0);
        this.nameEntry.setFormEntryListener(new FormTextEntryListenerAdapter(){

            public void textValueChanged(FormTextEntry entry) {
                GeneratorDetailsPage.this.generator.setGeneratorClassName(entry.getValue());
            }
        });
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IRevEngGenerator newTable = (IRevEngGenerator)((IStructuredSelection)selection).getFirstElement();
        if (this.generator != null) {
            this.generator.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (newTable != null) {
            newTable.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.generator = newTable;
        this.update();
    }

    private void update() {
        this.nameEntry.setValue(this.generator.getGeneratorClassName());
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.update();
    }
}

