/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.editors;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;

public class ChooseConsoleConfigurationDialog
extends TitleAreaDialog {
    private Combo text;
    String initialDefault;
    String selectedConfigurationName;

    public ChooseConsoleConfigurationDialog(Shell shell, String initialDefault) {
        super(shell);
        this.initialDefault = initialDefault;
    }

    public void prompt() {
        this.open();
        if (this.getReturnCode() == 1) {
            this.selectedConfigurationName = null;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.setTitle("Select a console configuration");
        if (this.getTitleImageLabel() != null) {
            this.getTitleImageLabel().setVisible(false);
        }
        this.createConsoleConfigBrowseRow(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Select a console configuration");
    }

    protected void okPressed() {
        this.selectedConfigurationName = this.text.getText();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selectedConfigurationName = null;
        super.cancelPressed();
    }

    private void createConsoleConfigBrowseRow(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(1808));
        panel.setFont(parent.getFont());
        Label label = new Label(panel, 0);
        label.setText("Console configuration:");
        this.text = new Combo(panel, 18444);
        this.text.setFocus();
        this.text.setLayoutData((Object)new GridData(768));
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button okButton = ChooseConsoleConfigurationDialog.this.getButton(0);
                if (okButton != null && !okButton.isDisposed()) {
                    okButton.setEnabled(!"".equals(ChooseConsoleConfigurationDialog.this.text.getText()));
                }
            }
        });
        this.setInitialTextValues(this.text);
    }

    private void setInitialTextValues(Combo text) {
        ConsoleConfiguration[] recentWorkspaces = KnownConfigurations.getInstance().getConfigurationsSortedByName();
        int i = 0;
        while (i < recentWorkspaces.length) {
            text.add(recentWorkspaces[i].getName());
            ++i;
        }
        text.setText(text.getItemCount() > 0 ? text.getItem(0) : this.initialDefault);
    }

    public String getSelectedConfigurationName() {
        return this.selectedConfigurationName;
    }
}

