/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.AssignmentEndDirective;
import org.jboss.ide.eclipse.freemarker.model.CompletionInterpolation;
import org.jboss.ide.eclipse.freemarker.model.Item;

public class AssignmentDirective
extends AbstractDirective {
    private AssignmentEndDirective endDirective;
    private String type;
    private Item[] relatedItems;
    Map contextValues;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AssignmentDirective(String type) {
        this.type = type;
    }

    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    public boolean isStartItem() {
        return super.isNestable();
    }

    public void relateItem(Item directive) {
        if (directive instanceof AssignmentEndDirective) {
            this.endDirective = (AssignmentEndDirective)directive;
        }
    }

    public boolean relatesToItem(Item directive) {
        return directive instanceof AssignmentEndDirective;
    }

    public boolean isNestable() {
        return this.getContents() != null && !this.getContents().endsWith("/");
    }

    public AssignmentEndDirective getEndDirective() {
        return this.endDirective;
    }

    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            ArrayList<AssignmentEndDirective> l = new ArrayList<AssignmentEndDirective>();
            if (this.endDirective != null) {
                l.add(this.endDirective);
            }
            this.relatedItems = l.toArray(new Item[l.size()]);
        }
        return this.relatedItems;
    }

    public String getTreeImage() {
        return "assign.png";
    }

    public void addToContext(Map context) {
        if (this.contextValues == null) {
            String[] values = this.splitContents();
            String key = null;
            String value = null;
            if (values.length >= 2) {
                key = values[1];
            }
            if (values.length >= 4) {
                value = values[3];
            }
            Class valueClass = null;
            if (value != null && value.length() > 0) {
                if (value.charAt(0) == '\"') {
                    Class clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    valueClass = clazz;
                } else if (Character.isDigit(value.charAt(0))) {
                    Class clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("java.lang.Number");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    valueClass = clazz;
                } else {
                    CompletionInterpolation completionInterpolation = new CompletionInterpolation("${" + value, 2, this.getItemSet(), this.getResource());
                    valueClass = completionInterpolation.getReturnClass(context);
                }
            }
            if (key != null) {
                context.put(key, valueClass);
            }
        }
        super.addToContext(context);
    }

    public Item getEndItem() {
        return this.endDirective;
    }
}

