/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.transaction.DummyBaseTransactionManager;

public class DummyTransaction
implements Transaction {
    int status = 5;
    static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$transaction$DummyTransaction == null ? (class$org$jboss$cache$transaction$DummyTransaction = DummyTransaction.class$("org.jboss.cache.transaction.DummyTransaction")) : class$org$jboss$cache$transaction$DummyTransaction));
    DummyBaseTransactionManager tm_;
    final List participants = new LinkedList();
    static /* synthetic */ Class class$org$jboss$cache$transaction$DummyTransaction;

    public DummyTransaction(DummyBaseTransactionManager tm) {
        this.tm_ = tm;
        this.status = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        this.status = 7;
        try {
            boolean doCommit;
            boolean outcome = this.notifyBeforeCompletion();
            if (outcome && this.status != 1) {
                this.status = 8;
                doCommit = true;
            } else {
                this.status = 9;
                doCommit = false;
            }
            this.notifyAfterCompletion(doCommit ? 3 : 1);
            int n = this.status = doCommit ? 3 : 1;
            if (!doCommit) {
                throw new RollbackException();
            }
        }
        finally {
            this.tm_.setTransaction(null);
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        try {
            this.status = 4;
            this.notifyAfterCompletion(4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.status = 4;
        this.tm_.setTransaction(null);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (sync == null) {
            throw new IllegalArgumentException("null synchronization " + this);
        }
        switch (this.status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("already prepared. " + this);
            }
            case 8: {
                throw new IllegalStateException("already started committing. " + this);
            }
            case 3: {
                throw new IllegalStateException("already committed. " + this);
            }
            case 1: {
                throw new RollbackException("already marked for rollback " + this);
            }
            case 9: {
                throw new RollbackException("already started rolling back. " + this);
            }
            case 4: {
                throw new RollbackException("already rolled back. " + this);
            }
            case 6: {
                throw new IllegalStateException("no transaction. " + this);
            }
            case 5: {
                throw new IllegalStateException("unknown state " + this);
            }
            default: {
                throw new IllegalStateException("illegal status: " + this.status + " tx=" + this);
            }
        }
        List list = this.participants;
        synchronized (list) {
            if (!this.participants.contains(sync)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("registering synchronization handler " + sync));
                }
                this.participants.add(sync);
            }
        }
    }

    void setStatus(int new_status) {
        this.status = new_status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyBeforeCompletion() {
        LinkedList tmp;
        boolean retval = true;
        List list = this.participants;
        synchronized (list) {
            tmp = new LinkedList(this.participants);
        }
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            Synchronization s = (Synchronization)it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing beforeCompletion for " + s));
            }
            try {
                s.beforeCompletion();
            }
            catch (Throwable t) {
                retval = false;
                log.error((Object)("beforeCompletion() failed for " + s), t);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyAfterCompletion(int status) {
        LinkedList tmp;
        List list = this.participants;
        synchronized (list) {
            tmp = new LinkedList(this.participants);
        }
        Iterator it = tmp.iterator();
        while (it.hasNext()) {
            Synchronization s = (Synchronization)it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("processing afterCompletion for " + s));
            }
            try {
                s.afterCompletion(status);
            }
            catch (Throwable t) {
                log.error((Object)("afterCompletion() failed for " + s), t);
            }
        }
        list = this.participants;
        synchronized (list) {
            this.participants.clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

