/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.statetransfer;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCache;
import org.jboss.cache.aop.InternalDelegate;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.aop.util.ObjectUtil;
import org.jboss.cache.loader.ExtendedCacheLoader;
import org.jboss.cache.loader.NodeData;
import org.jboss.cache.statetransfer.StateTransferGenerator;
import org.jboss.cache.util.ExposedByteArrayOutputStream;
import org.jboss.invocation.MarshalledValueOutputStream;

class StateTransferGenerator_1241
implements StateTransferGenerator {
    public static final short STATE_TRANSFER_VERSION = 1241;
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private TreeCache cache;

    StateTransferGenerator_1241(TreeCache cache) {
        this.cache = cache;
    }

    public byte[] generateStateTransfer(DataNode rootNode, boolean generateTransient, boolean generatePersistent, boolean suppressErrors) throws Throwable {
        int lastSize;
        boolean debug = this.log.isDebugEnabled();
        Fqn fqn = rootNode.getFqn();
        byte[][] states = new byte[3][];
        states[2] = null;
        states[1] = null;
        states[0] = null;
        int[] sizes = new int[3];
        byte[] retval = null;
        ExposedByteArrayOutputStream baos = new ExposedByteArrayOutputStream(1024);
        try {
            this.initializeStateTransfer(baos);
            lastSize = baos.size();
        }
        catch (Throwable t) {
            this.log.error((Object)"failed initialing state transfer byte[]", t);
            if (!suppressErrors) {
                throw t;
            }
            return null;
        }
        try {
            if (generateTransient) {
                MarshalledValueOutputStream out = new MarshalledValueOutputStream((OutputStream)baos);
                this.marshallTransientState(rootNode, (ObjectOutputStream)out);
                out.close();
                sizes[0] = baos.size() - lastSize;
                lastSize = baos.size();
                if (debug) {
                    this.log.debug((Object)("generated the in-memory state (" + sizes[0] + " bytes)"));
                }
                if (this.cache instanceof TreeCacheAop) {
                    out = new MarshalledValueOutputStream((OutputStream)baos);
                    this.marshallAssociatedState(fqn, (ObjectOutputStream)out);
                    out.close();
                    sizes[1] = baos.size() - lastSize;
                    lastSize = baos.size();
                    if (debug) {
                        this.log.debug((Object)("returning the associated state (" + sizes[1] + " bytes)"));
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"failed getting the in-memory (transient) state", t);
            if (!suppressErrors) {
                throw t;
            }
            sizes[1] = 0;
            sizes[0] = 0;
            baos.reset();
            try {
                this.initializeStateTransfer(baos);
            }
            catch (Throwable t1) {
                this.log.error((Object)"failed re-initializing state transfer", t1);
                return null;
            }
        }
        if (generatePersistent) {
            try {
                if (debug) {
                    this.log.debug((Object)"getting the persistent state");
                }
                byte[] persState = null;
                persState = fqn.size() == 0 ? this.cache.getCacheLoader().loadEntireState() : ((ExtendedCacheLoader)this.cache.getCacheLoader()).loadState(fqn);
                if (persState != null) {
                    sizes[2] = persState.length;
                    baos.write(persState);
                }
                if (debug) {
                    this.log.debug((Object)("generated the persistent state (" + sizes[2] + " bytes)"));
                }
            }
            catch (Throwable t) {
                this.log.error((Object)"failed getting the persistent state", t);
                if (!suppressErrors) {
                    throw t;
                }
                sizes[2] = 0;
            }
        }
        try {
            byte[] bytes = baos.getRawBuffer();
            StateTransferGenerator_1241.overwriteInt(bytes, 8, sizes[0]);
            StateTransferGenerator_1241.overwriteInt(bytes, 12, sizes[1]);
            StateTransferGenerator_1241.overwriteInt(bytes, 16, sizes[2]);
            retval = bytes;
            this.log.info((Object)("returning the state for tree rooted in " + fqn.toString() + "(" + retval.length + " bytes)"));
            return retval;
        }
        catch (Throwable t) {
            this.log.error((Object)"failed serializing transient and persistent state", t);
            if (!suppressErrors) {
                throw t;
            }
            return null;
        }
    }

    private void initializeStateTransfer(OutputStream baos) throws IOException {
        MarshalledValueOutputStream out = new MarshalledValueOutputStream(baos);
        out.writeShort(1241);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
        out.close();
    }

    private void marshallTransientState(DataNode node, ObjectOutputStream out) throws Exception {
        Map attrs = node.getData();
        NodeData nd = attrs == null || attrs.size() == 0 ? new NodeData(node.getFqn()) : new NodeData(node.getFqn(), attrs);
        out.writeObject(nd);
        Map children = node.getChildren();
        if (children == null) {
            return;
        }
        Iterator it = children.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.marshallTransientState((DataNode)entry.getValue(), out);
        }
    }

    private void marshallAssociatedState(Fqn fqn, ObjectOutputStream out) throws Exception {
        if (fqn == null || fqn.size() == 0 || fqn.isChildOf(InternalDelegate.JBOSS_INTERNAL)) {
            return;
        }
        DataNode refMapNode = this.cache.get(InternalDelegate.JBOSS_INTERNAL_MAP);
        Map children = null;
        if (refMapNode != null && (children = refMapNode.getChildren()) != null) {
            String targetFqn = ObjectUtil.getIndirectFqn(fqn.toString());
            Iterator iter = children.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(targetFqn)) continue;
                DataNode value = (DataNode)entry.getValue();
                out.writeObject(new Object[]{key, value.get(key)});
            }
        }
    }

    static void overwriteInt(byte[] bytes, int startpos, int newVal) {
        bytes[startpos] = (byte)(newVal >>> 24);
        bytes[startpos + 1] = (byte)(newVal >>> 16);
        bytes[startpos + 2] = (byte)(newVal >>> 8);
        bytes[startpos + 3] = (byte)(newVal >>> 0);
    }
}

