/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.optimistic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.DataNode;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Node;
import org.jboss.cache.OptimisticTreeNode;
import org.jboss.cache.TreeCache;
import org.jboss.cache.factories.NodeFactory;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.LockingException;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.logging.Logger;

public class WorkspaceNodeImpl
implements WorkspaceNode {
    private static transient Logger log = Logger.getLogger((Class)(class$org$jboss$cache$optimistic$WorkspaceNodeImpl == null ? (class$org$jboss$cache$optimistic$WorkspaceNodeImpl = WorkspaceNodeImpl.class$("org.jboss.cache.optimistic.WorkspaceNodeImpl")) : class$org$jboss$cache$optimistic$WorkspaceNodeImpl));
    private DataNode node;
    private TransactionWorkspace workspace;
    private boolean dirty = false;
    private DataVersion version = new DefaultDataVersion();
    private boolean deleted;
    private Fqn fqn;
    private boolean created;
    private Map optimisticChildNodeMap;
    private Map optimisticDataMap;
    static /* synthetic */ Class class$org$jboss$cache$optimistic$WorkspaceNodeImpl;

    public boolean isDirty() {
        return this.dirty;
    }

    public WorkspaceNodeImpl(Node node, TransactionWorkspace workspace) {
        this.node = (DataNode)node;
        this.workspace = workspace;
        this.optimisticDataMap = node.getData();
        if (this.optimisticDataMap == null) {
            this.optimisticDataMap = new HashMap();
        }
        this.optimisticChildNodeMap = node.getChildren() == null ? new HashMap() : new HashMap(node.getChildren());
        this.version = ((OptimisticTreeNode)node).getVersion();
        this.fqn = node.getFqn();
    }

    public WorkspaceNodeImpl(DataNode node, TransactionWorkspace workspace) {
        this.node = node;
        this.workspace = workspace;
        this.optimisticDataMap = node.getData();
        if (this.optimisticDataMap == null) {
            this.optimisticDataMap = new HashMap();
        }
        this.optimisticChildNodeMap = node.getChildren() == null ? new HashMap() : new HashMap(node.getChildren());
        this.version = ((OptimisticTreeNode)node).getVersion();
        this.fqn = node.getFqn();
    }

    public Fqn getFqn() {
        return this.fqn;
    }

    public void put(Map data, boolean eraseData) {
        this.realPut(data, eraseData);
        this.dirty = true;
    }

    public void put(Map data) {
        this.realPut(data, false);
        this.dirty = true;
    }

    public Object put(Object key, Object value) {
        this.dirty = true;
        return this.optimisticDataMap.put(key, value);
    }

    public Object remove(Object key) {
        this.dirty = true;
        return this.optimisticDataMap.remove(key);
    }

    public void clear() {
        this.optimisticDataMap.clear();
        this.dirty = true;
    }

    public Object get(Object key) {
        return this.optimisticDataMap.get(key);
    }

    public Set getKeys() {
        return this.optimisticDataMap.keySet();
    }

    public Set getChildrenNames() {
        HashSet set = new HashSet();
        set.addAll(this.optimisticChildNodeMap.keySet());
        return set;
    }

    private void realPut(Map data, boolean eraseData) {
        this.realPut(data, eraseData, true);
    }

    private void realPut(Map data, boolean eraseData, boolean forceDirtyFlag) {
        if (forceDirtyFlag) {
            this.dirty = true;
        }
        if (eraseData) {
            this.optimisticDataMap.clear();
        }
        this.optimisticDataMap.putAll(data);
    }

    public void removeChild(Object childName) {
        this.dirty = true;
        this.optimisticChildNodeMap.remove(childName);
    }

    public Node getParent() {
        return this.node.getParent();
    }

    public Node getWrappedParent() {
        WorkspaceNode workspaceNode = this.workspace.getNode(this.node.getParent().getFqn());
        if (workspaceNode == null) {
            workspaceNode = NodeFactory.getInstance().createWorkspaceNode(this.node.getParent(), this.workspace);
            this.workspace.addNode(workspaceNode);
        }
        return workspaceNode;
    }

    public Node createChild(Object child_name, Fqn fqn, Node parent) {
        log.error((Object)"Not implemented here!!");
        return null;
    }

    public Node createChild(Object child_name, Fqn fqn, Node parent, TreeCache cache, DataVersion version) {
        if (child_name == null) {
            return null;
        }
        Node child = (Node)this.optimisticChildNodeMap.get(child_name);
        if (child == null) {
            child = NodeFactory.getInstance().createNodeOfType(parent, child_name, fqn, parent, null, cache, version);
            this.optimisticChildNodeMap.put(child_name, child);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)new StringBuffer("createChild: fqn=").append(fqn).append(", child_name=").append(child_name));
        }
        this.dirty = true;
        return child;
    }

    public Node getChild(Object childName) {
        return (Node)this.optimisticChildNodeMap.get(childName);
    }

    public Node getWrappedChild(Object fqn) {
        DataNode temp;
        WorkspaceNode wrapper = this.workspace.getNode((Fqn)fqn);
        if (wrapper == null && (temp = (DataNode)this.optimisticChildNodeMap.get(fqn)) != null) {
            wrapper = new WorkspaceNodeImpl(temp, this.workspace);
            this.workspace.addNode(wrapper);
        }
        return wrapper;
    }

    public DataNode getNode() {
        return this.node;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public void setVersion(DataVersion version) {
        this.version = version;
    }

    public Map getMergedChildren() {
        return this.optimisticChildNodeMap;
    }

    public Map getMergedData() {
        return this.optimisticDataMap;
    }

    public void markAsDeleted() {
        this.deleted = true;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public Object getName() {
        return this.node.getName();
    }

    public TransactionWorkspace getTransactionWorkspace() {
        return this.workspace;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void markAsCreated() {
        this.created = true;
        this.dirty = true;
    }

    public Map getData() {
        return null;
    }

    public Map getChildren() {
        return null;
    }

    public boolean containsKey(Object key) {
        return false;
    }

    public Set getDataKeys() {
        return null;
    }

    public boolean childExists(Object child_name) {
        return false;
    }

    public IdentityLock getImmutableLock() {
        return null;
    }

    public IdentityLock getLock() {
        return null;
    }

    public int numAttributes() {
        return 0;
    }

    public boolean hasChildren() {
        return false;
    }

    public Node getOrCreateChild(Object child_name, GlobalTransaction gtx, boolean createIfNotExists) {
        return null;
    }

    public Node createChild(Object child_name, Fqn fqn, Node parent, Object key, Object value) {
        return null;
    }

    public void removeAllChildren() {
    }

    public void print(StringBuffer sb, int indent) {
    }

    public void printDetails(StringBuffer sb, int indent) {
    }

    public void printIndent(StringBuffer sb, int indent) {
    }

    public void addChild(Object child_name, Node n) {
    }

    public void printLockInfo(StringBuffer sb, int indent) {
    }

    public boolean isLocked() {
        return false;
    }

    public void releaseAll(Object owner) {
    }

    public void releaseAllForce() {
    }

    public Set acquireAll(Object caller, long timeout, int lock_type) throws LockingException, TimeoutException, InterruptedException {
        return null;
    }

    public void setRecursiveTreeCacheInstance(TreeCache cache) {
    }

    public boolean getChildrenLoaded() {
        return false;
    }

    public void setChildrenLoaded(boolean b) {
    }

    public void setChildren(Map children) {
    }

    public void release(Object caller) {
    }

    public void releaseForce() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        if (this.fqn != null) {
            sb.append(" Fqn=" + this.fqn);
        }
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

