/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.OptimisticTransactionEntry;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.Option;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.OrderedSynchronizationHandler;
import org.jboss.cache.interceptors.TxInterceptorMBean;
import org.jboss.util.NestedRuntimeException;
import org.jgroups.Address;
import org.jgroups.blocks.MethodCall;

public class TxInterceptor
extends Interceptor
implements TxInterceptorMBean {
    private Map transactions = new ConcurrentHashMap(16);
    private Map rollbackTransactions = new ConcurrentHashMap(16);
    private long m_prepares = 0L;
    private long m_commits = 0L;
    private long m_rollbacks = 0L;
    static final Object NULL = new Object();
    protected TransactionManager txManager = null;
    protected TransactionTable txTable = null;
    private Map remoteTransactions = new ConcurrentHashMap();
    static /* synthetic */ Class class$org$jboss$cache$GlobalTransaction;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.txManager = cache.getTransactionManager();
        this.txTable = cache.getTransactionTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(MethodCall m) throws Throwable {
        Object result;
        block29: {
            InvocationContext ctx;
            block27: {
                boolean resumeSuspended;
                Transaction suspendedTransaction;
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("(" + this.cache.getLocalAddress() + ") call on method [" + m + "]"));
                }
                ctx = this.getInvocationContext();
                Option optionOverride = ctx.getOptionOverrides();
                ctx.setTransaction(this.txManager == null ? null : this.txManager.getTransaction());
                if (optionOverride != null && optionOverride.isFailSilently() && ctx.getTransaction() != null) {
                    suspendedTransaction = this.txManager.suspend();
                    resumeSuspended = true;
                } else {
                    suspendedTransaction = null;
                    resumeSuspended = false;
                }
                Method meth = m.getMethod();
                result = null;
                try {
                    block26: {
                        try {
                            if (this.isTransactionLifecycleMethod(meth)) {
                                ctx.setGlobalTransaction(this.findGlobalTransaction(m.getArgs()));
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)("Got gtx from method call " + ctx.getGlobalTransaction()));
                                }
                                ctx.getGlobalTransaction().setRemote(this.isRemoteGlobalTx(ctx.getGlobalTransaction()));
                                if (ctx.getGlobalTransaction().isRemote()) {
                                    this.remoteTransactions.put(ctx.getGlobalTransaction(), NULL);
                                }
                                if (meth.equals(TreeCache.optimisticPrepareMethod) || meth.equals(TreeCache.prepareMethod)) {
                                    if (ctx.getGlobalTransaction().isRemote()) {
                                        result = this.handleRemotePrepare(m, ctx.getGlobalTransaction());
                                        if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
                                            ++this.m_prepares;
                                        }
                                        break block26;
                                    }
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace((Object)"received my own message (discarding it)");
                                    }
                                    result = null;
                                    break block26;
                                }
                                if (!meth.equals(TreeCache.commitMethod) && !meth.equals(TreeCache.rollbackMethod)) break block26;
                                if (ctx.getGlobalTransaction().isRemote()) {
                                    result = this.handleRemoteCommitRollback(m, ctx.getGlobalTransaction());
                                    break block26;
                                } else {
                                    if (this.log.isTraceEnabled()) {
                                        this.log.trace((Object)"received my own message (discarding it)");
                                    }
                                    result = null;
                                }
                                break block26;
                            }
                            result = this.handleNonTxMethod(m);
                        }
                        catch (Exception e) {
                            this.log.info((Object)"There was a problem handling this request", (Throwable)e);
                            if (optionOverride == null) throw e;
                            if (!optionOverride.isFailSilently()) {
                                throw e;
                            }
                            Object var10_9 = null;
                            if (resumeSuspended) {
                                this.txManager.resume(suspendedTransaction);
                            } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                                this.copyInvocationScopeOptionsToTxScope(ctx);
                            }
                            this.scrubInvocationCtx(false);
                            return result;
                        }
                    }
                    Object var10_8 = null;
                    if (!resumeSuspended) break block27;
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (resumeSuspended) {
                        this.txManager.resume(suspendedTransaction);
                    } else if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                        this.copyInvocationScopeOptionsToTxScope(ctx);
                    }
                    this.scrubInvocationCtx(false);
                    throw throwable;
                }
                this.txManager.resume(suspendedTransaction);
                break block29;
            }
            if (ctx.getTransaction() != null && this.isValid(ctx.getTransaction())) {
                this.copyInvocationScopeOptionsToTxScope(ctx);
            }
        }
        this.scrubInvocationCtx(false);
        return result;
    }

    public long getPrepares() {
        return this.m_prepares;
    }

    public long getCommits() {
        return this.m_commits;
    }

    public long getRollbacks() {
        return this.m_rollbacks;
    }

    public void resetStatistics() {
        this.m_prepares = 0L;
        this.m_commits = 0L;
        this.m_rollbacks = 0L;
    }

    public Map dumpStatistics() {
        HashMap<String, Long> retval = new HashMap<String, Long>(3);
        retval.put("prepares", new Long(this.m_prepares));
        retval.put("commits", new Long(this.m_commits));
        retval.put("rollbacks", new Long(this.m_rollbacks));
        return retval;
    }

    protected GlobalTransaction findGlobalTransaction(Object[] params) {
        int clue = 0;
        if (params[clue] instanceof GlobalTransaction) {
            return (GlobalTransaction)params[clue];
        }
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof GlobalTransaction)) continue;
            return (GlobalTransaction)params[i];
        }
        return null;
    }

    private void copyInvocationScopeOptionsToTxScope(InvocationContext ctx) {
        TransactionEntry entry = this.txTable.get(ctx.getGlobalTransaction());
        if (entry != null) {
            Option txScopeOption = new Option();
            txScopeOption.setCacheModeLocal(ctx.getOptionOverrides() != null && ctx.getOptionOverrides().isCacheModeLocal());
            entry.setOption(txScopeOption);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleRemotePrepare(MethodCall m, GlobalTransaction gtx) throws Throwable {
        List modifications = (List)m.getArgs()[1];
        boolean onePhase = (Boolean)m.getArgs()[this.cache.isNodeLockingOptimistic() ? 4 : 3];
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        Transaction currentTx = this.txManager.getTransaction();
        Object retval = null;
        try {
            if (ltx == null) {
                ltx = this.createLocalTxForGlobalTx(gtx);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("(" + this.cache.getLocalAddress() + "): started new local TX as result of remote PREPARE: local TX=" + ltx + ", global TX=" + gtx));
                }
            } else if (!this.isValid(ltx)) {
                throw new CacheException("Transaction " + ltx + " not in correct state to be prepared");
            }
            if (currentTx == null || !ltx.equals(currentTx)) {
                this.txManager.suspend();
                this.txManager.resume(ltx);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Resuming existing transaction " + ltx + ", global TX=" + gtx));
            }
            if (this.txTable.get(gtx) == null) {
                TransactionEntry entry = this.cache.isNodeLockingOptimistic() ? new OptimisticTransactionEntry() : new TransactionEntry();
                entry.setTransaction(ltx);
                this.log.debug((Object)"creating new optimistic tx entry");
                this.txTable.put(gtx, entry);
            }
            this.registerHandler(ltx, new RemoteSynchronizationHandler(gtx, ltx, this.cache));
            retval = this.cache.isNodeLockingOptimistic() ? this.handleOptimisticPrepare(m, gtx, modifications, onePhase, ltx) : this.handlePessimisticPrepare(m, gtx, modifications, onePhase, ltx);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.txManager.suspend();
            if (currentTx != null) {
                this.txManager.resume(currentTx);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Finished remote prepare " + gtx));
            }
            throw throwable;
        }
        this.txManager.suspend();
        if (currentTx != null) {
            this.txManager.resume(currentTx);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished remote prepare " + gtx));
        }
        return retval;
    }

    /*
     * WARNING - void declaration
     */
    private Object handleNonTxMethod(MethodCall m) throws Throwable {
        void var4_5;
        Object result;
        boolean implicitTransaction;
        InvocationContext ctx = this.getInvocationContext();
        Transaction tx = ctx.getTransaction();
        boolean bl = implicitTransaction = this.cache.isNodeLockingOptimistic() && tx == null;
        if (implicitTransaction) {
            tx = this.createLocalTx();
            ctx.setTransaction(tx);
        }
        if (tx != null) {
            m = this.attachGlobalTransaction(tx, m);
        }
        try {
            result = super.invoke(m);
            if (implicitTransaction) {
                this.copyInvocationScopeOptionsToTxScope(ctx);
                this.txManager.commit();
            }
        }
        catch (Throwable t) {
            if (implicitTransaction) {
                this.log.warn((Object)"Rolling back, exception encountered", t);
                result = t;
                try {
                    this.txManager.rollback();
                }
                catch (Throwable th) {
                    this.log.warn((Object)"Roll back failed encountered", th);
                }
            }
            throw t;
        }
        return var4_5;
    }

    private MethodCall attachGlobalTransaction(Transaction tx, MethodCall m) throws Exception {
        GlobalTransaction gtx;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" local transaction exists - registering global tx if not present for " + Thread.currentThread()));
        }
        if (this.log.isTraceEnabled()) {
            GlobalTransaction tempGtx = this.txTable.get(tx);
            this.log.trace((Object)("Associated gtx in txTable is " + tempGtx));
        }
        if ((gtx = this.registerTransaction(tx)) != null) {
            m = this.replaceGtx(m, gtx);
        } else {
            gtx = this.txTable.get(tx);
        }
        this.getInvocationContext().setGlobalTransaction(gtx);
        return m;
    }

    private Object handleOptimisticPrepare(MethodCall m, GlobalTransaction gtx, List modifications, boolean onePhase, Transaction ltx) throws Throwable {
        Object retval = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Handling optimistic remote prepare " + gtx));
        }
        retval = this.replayModifications(modifications, ltx);
        retval = super.invoke(m);
        if (!this.isActive(ltx)) {
            throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + ltx.getStatus());
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object handlePessimisticPrepare(MethodCall m, GlobalTransaction gtx, List modifications, boolean commit, Transaction ltx) throws Exception {
        boolean success = true;
        Object retval = null;
        try {
            block21: {
                try {
                    this.replayModifications(modifications, ltx);
                    retval = super.invoke(m);
                    if (!this.isActive(ltx)) {
                        throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + ltx.getStatus());
                    }
                }
                catch (Throwable th) {
                    this.log.error((Object)"prepare method invocation failed", th);
                    retval = th;
                    success = false;
                    if (!(retval instanceof Exception)) break block21;
                    throw (Exception)retval;
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Are we running a 1-phase commit? " + commit));
            }
            if (!commit) throw throwable;
            try {
                if (success) {
                    ltx.commit();
                } else {
                    ltx.rollback();
                }
                this.transactions.remove(ltx);
            }
            catch (Throwable t) {
                try {}
                catch (Throwable throwable2) {
                    this.transactions.remove(ltx);
                    this.remoteTransactions.remove(gtx);
                    throw throwable2;
                }
                this.log.error((Object)"Commit/rollback failed.", t);
                if (success) {
                    try {
                        this.log.info((Object)"Attempting anotehr rollback");
                        ltx.rollback();
                    }
                    catch (Throwable t2) {
                        this.log.error((Object)"Unable to rollback", t2);
                    }
                }
                this.transactions.remove(ltx);
                this.remoteTransactions.remove(gtx);
                throw throwable;
            }
            this.remoteTransactions.remove(gtx);
            throw throwable;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Are we running a 1-phase commit? " + commit));
        }
        if (!commit) return null;
        try {
            if (success) {
                ltx.commit();
                return null;
            }
            ltx.rollback();
            return null;
        }
        catch (Throwable t) {
            this.log.error((Object)"Commit/rollback failed.", t);
            if (!success) return null;
            try {
                this.log.info((Object)"Attempting anotehr rollback");
                ltx.rollback();
                return null;
            }
            catch (Throwable t2) {
                this.log.error((Object)"Unable to rollback", t2);
            }
            return null;
        }
        finally {
            this.transactions.remove(ltx);
            this.remoteTransactions.remove(gtx);
        }
    }

    private Object replayModifications(List modifications, Transaction tx) {
        Object retval = null;
        if (modifications != null) {
            Iterator it = modifications.iterator();
            while (it.hasNext()) {
                MethodCall method_call = (MethodCall)it.next();
                try {
                    retval = super.invoke(method_call);
                    if (!this.isActive(tx)) {
                        throw new ReplicationException("prepare() failed -- local transaction status is not STATUS_ACTIVE; is " + tx.getStatus());
                    }
                }
                catch (Throwable t) {
                    this.log.error((Object)"method invocation failed", t);
                    retval = t;
                }
                if (retval == null || !(retval instanceof Exception)) continue;
                throw new NestedRuntimeException((Throwable)((Exception)retval));
            }
        }
        return retval;
    }

    private void invokeOnePhaseCommitMethod(GlobalTransaction gtx, boolean hasMods, boolean isSuccessful) throws Throwable {
        MethodCall c = new MethodCall(isSuccessful ? TreeCache.commitMethod : TreeCache.rollbackMethod, new Object[]{gtx, hasMods ? Boolean.TRUE : Boolean.FALSE});
        super.invoke(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleRemoteCommitRollback(MethodCall m, GlobalTransaction gtx) throws Throwable {
        Transaction ltx;
        block14: {
            ltx = this.getLocalTxForGlobalTx(gtx);
            Transaction currentTx = this.txManager.getTransaction();
            boolean resumeCurrentTxOnCompletion = false;
            try {
                if (!ltx.equals(currentTx)) {
                    currentTx = this.txManager.suspend();
                    resumeCurrentTxOnCompletion = true;
                    this.txManager.resume(ltx);
                    this.getInvocationContext().setTransaction(ltx);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(" executing " + m + "() with local TX " + ltx + " under global tx " + gtx));
                }
                if (TreeCache.commitMethod.equals(m.getMethod())) {
                    this.txManager.commit();
                    if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
                        ++this.m_commits;
                    }
                } else {
                    this.txManager.rollback();
                    if (this.cache.getUseInterceptorMbeans() && this.statsEnabled) {
                        ++this.m_rollbacks;
                    }
                }
                Object var7_6 = null;
                if (!resumeCurrentTxOnCompletion) break block14;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (resumeCurrentTxOnCompletion) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Resuming suspended transaction " + currentTx));
                    }
                    this.txManager.suspend();
                    if (currentTx != null) {
                        this.txManager.resume(currentTx);
                        this.getInvocationContext().setTransaction(currentTx);
                    }
                }
                this.remoteTransactions.remove(gtx);
                this.transactions.remove(ltx);
                this.txTable.remove(gtx);
                this.txTable.remove(ltx);
                throw throwable;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Resuming suspended transaction " + currentTx));
            }
            this.txManager.suspend();
            if (currentTx != null) {
                this.txManager.resume(currentTx);
                this.getInvocationContext().setTransaction(currentTx);
            }
        }
        this.remoteTransactions.remove(gtx);
        this.transactions.remove(ltx);
        this.txTable.remove(gtx);
        this.txTable.remove(ltx);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished remote commit/rollback method for " + gtx));
        }
        return null;
    }

    private Transaction getLocalTxForGlobalTx(GlobalTransaction gtx) throws IllegalStateException {
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        if (ltx != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Found local TX=" + ltx + ", global TX=" + gtx));
            }
        } else {
            throw new IllegalStateException(" found no local TX for global TX " + gtx);
        }
        return ltx;
    }

    private Object handleCommitRollback(MethodCall m) throws Throwable {
        Transaction currentTx;
        GlobalTransaction gtx = this.findGlobalTransaction(m.getArgs());
        Object result = null;
        Transaction ltx = this.getLocalTxForGlobalTx(gtx);
        if (!ltx.equals(currentTx = this.txManager.getTransaction())) {
            throw new IllegalStateException(" local transaction " + ltx + " transaction does not match running tx " + currentTx);
        }
        result = super.invoke(m);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Finished local commit/rollback method for " + gtx));
        }
        return result;
    }

    protected void runCommitPhase(GlobalTransaction gtx, List modifications, boolean onePhaseCommit) {
        boolean hasMods = modifications != null && modifications.size() > 0;
        try {
            MethodCall commitMethod = null;
            commitMethod = onePhaseCommit ? (this.cache.isNodeLockingOptimistic() ? new MethodCall(TreeCache.optimisticPrepareMethod, new Object[]{gtx, modifications, null, (Address)this.cache.getLocalAddress(), Boolean.TRUE}) : new MethodCall(TreeCache.prepareMethod, new Object[]{gtx, modifications, (Address)this.cache.getLocalAddress(), Boolean.TRUE})) : new MethodCall(TreeCache.commitMethod, new Object[]{gtx, hasMods ? Boolean.TRUE : Boolean.FALSE});
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)(" running commit for " + gtx));
            }
            this.handleCommitRollback(commitMethod);
        }
        catch (Throwable e) {
            this.log.error((Object)"Commit failed, rolling back.", e);
            Transaction tx = null;
            try {
                tx = this.txManager.getTransaction();
                tx.setRollbackOnly();
            }
            catch (Exception e2) {
                this.log.error((Object)"Unable to roll back transaction", (Throwable)e2);
            }
            throw new NestedRuntimeException("Commit failed, marking tx to be rolled back.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runRollbackPhase(GlobalTransaction gtx, List modifications) {
        Transaction ltx = null;
        try {
            try {
                boolean hasMods = modifications != null && modifications.size() > 0;
                MethodCall rollbackMethod = new MethodCall(TreeCache.rollbackMethod, new Object[]{gtx, hasMods ? Boolean.TRUE : Boolean.FALSE});
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)(" running rollback for " + gtx));
                }
                ltx = this.getLocalTxForGlobalTx(gtx);
                this.rollbackTransactions.put(ltx, gtx);
                this.handleCommitRollback(rollbackMethod);
            }
            catch (Throwable e) {
                this.log.warn((Object)"Rollback had a problem", e);
                Object var7_8 = null;
                if (ltx == null) return;
                this.rollbackTransactions.remove(ltx);
                return;
            }
            Object var7_7 = null;
            if (ltx == null) return;
            this.rollbackTransactions.remove(ltx);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (ltx == null) throw throwable;
            this.rollbackTransactions.remove(ltx);
            throw throwable;
        }
    }

    protected Object runPreparePhase(GlobalTransaction gtx, List modifications) throws Throwable {
        MethodCall prepareMethod = null;
        if (this.cache.isNodeLockingOptimistic()) {
            prepareMethod = new MethodCall(TreeCache.optimisticPrepareMethod, new Object[]{gtx, modifications, null, (Address)this.cache.getLocalAddress(), Boolean.FALSE});
        } else if (this.cache.getCacheModeInternal() != 2) {
            prepareMethod = new MethodCall(TreeCache.prepareMethod, new Object[]{gtx, modifications, (Address)this.cache.getLocalAddress(), Boolean.FALSE});
        } else {
            this.log.trace((Object)"This is a REPL_ASYNC call (1 phase commit) - do nothing for beforeCompletion()");
            return null;
        }
        Object result = null;
        Transaction ltx = this.txTable.getLocalTransaction(gtx);
        if (this.txManager.getTransaction() == null || ltx == null || !this.txManager.getTransaction().equals(ltx)) {
            this.log.warn((Object)("Local transaction does not exist or does not match expected transaction " + gtx));
            throw new CacheException(" local transaction " + ltx + " does not exist or does not match expected transaction " + gtx);
        }
        result = super.invoke(prepareMethod);
        return result;
    }

    private boolean isRemoteGlobalTx(GlobalTransaction gtx) {
        return gtx != null && gtx.getAddress() != null && !gtx.getAddress().equals(this.cache.getLocalAddress());
    }

    private GlobalTransaction registerTransaction(Transaction tx) throws Exception {
        GlobalTransaction gtx = null;
        if (!this.transactions.containsKey(tx) && this.isValid(tx)) {
            gtx = this.cache.getCurrentTransaction(tx);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Registering sync handler for tx " + tx + ", gtx " + gtx));
            }
            LocalSynchronizationHandler myHandler = new LocalSynchronizationHandler(gtx, tx, this.cache);
            this.registerHandler(tx, myHandler);
            this.transactions.put(tx, NULL);
        } else {
            gtx = (GlobalTransaction)this.rollbackTransactions.get(tx);
            if (gtx != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Transaction " + tx + " is already registered and is rolling back."));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Transaction " + tx + " is already registered."));
            }
        }
        return gtx;
    }

    private void registerHandler(Transaction tx, RemoteSynchronizationHandler handler) throws Exception {
        OrderedSynchronizationHandler orderedHandler = OrderedSynchronizationHandler.getInstance(tx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("registering for TX completion: \u00bbSynchronizationHandler(" + handler + ")"));
        }
        orderedHandler.registerAtHead(handler);
    }

    private MethodCall replaceGtx(MethodCall m, GlobalTransaction gtx) {
        Class<?>[] argClasses = m.getMethod().getParameterTypes();
        Object[] args = m.getArgs();
        for (int i = 0; i < argClasses.length; ++i) {
            if (!argClasses[i].equals(class$org$jboss$cache$GlobalTransaction == null ? TxInterceptor.class$("org.jboss.cache.GlobalTransaction") : class$org$jboss$cache$GlobalTransaction)) continue;
            if (gtx.equals(args[i])) break;
            args[i] = gtx;
            m.setArgs(args);
            break;
        }
        return m;
    }

    private Transaction createLocalTx() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Creating transaction for thread " + Thread.currentThread()));
        }
        if (this.txManager == null) {
            throw new Exception("Failed to create local transaction; TransactionManager is null");
        }
        this.txManager.begin();
        Transaction localTx = this.txManager.getTransaction();
        return localTx;
    }

    private Transaction createLocalTxForGlobalTx(GlobalTransaction gtx) throws Exception {
        Transaction localTx = this.createLocalTx();
        this.txTable.put(localTx, gtx);
        this.getInvocationContext().setTransaction(localTx);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Created new tx for gtx " + gtx));
        }
        return localTx;
    }

    private void setInvocationContext(Transaction tx, GlobalTransaction gtx) {
        InvocationContext ctx = this.getInvocationContext();
        ctx.setTransaction(tx);
        ctx.setGlobalTransaction(gtx);
    }

    private void scrubInvocationCtx(boolean removeTxs) {
        if (removeTxs) {
            this.setInvocationContext(null, null);
        }
        this.getInvocationContext().setOptionOverrides(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LocalSynchronizationHandler
    extends RemoteSynchronizationHandler {
        LocalSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            super(gtx, tx, cache);
        }

        public void beforeCompletion() {
            super.beforeCompletion();
            TxInterceptor.this.setInvocationContext(this.tx, this.gtx);
            if (this.modifications.size() == 0) {
                if (TxInterceptor.this.log.isTraceEnabled()) {
                    TxInterceptor.this.log.trace((Object)"No modifications in this tx.  Skipping beforeCompletion()");
                }
                return;
            }
            TxInterceptor.this.getInvocationContext().setOptionOverrides(this.entry.getOption());
            try {
                switch (this.tx.getStatus()) {
                    case 0: 
                    case 7: {
                        Object result = TxInterceptor.this.runPreparePhase(this.gtx, this.modifications);
                        if (result instanceof Throwable) {
                            this.tx.setRollbackOnly();
                            throw (Throwable)result;
                        }
                        break;
                    }
                    default: {
                        throw new CacheException("transaction " + this.tx + " in status " + this.tx.getStatus() + " unbale to start transaction");
                    }
                }
            }
            catch (Throwable t) {
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException se) {
                    throw new NestedRuntimeException("setting tx rollback failed ", (Throwable)se);
                }
                throw new NestedRuntimeException("", t);
            }
            finally {
                TxInterceptor.this.scrubInvocationCtx(false);
            }
        }

        public String toString() {
            return "TxInterceptor.LocalSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }

    class RemoteSynchronizationHandler
    implements Synchronization {
        Transaction tx = null;
        GlobalTransaction gtx = null;
        TreeCache cache = null;
        List modifications = null;
        TransactionEntry entry = null;

        RemoteSynchronizationHandler(GlobalTransaction gtx, Transaction tx, TreeCache cache) {
            this.gtx = gtx;
            this.tx = tx;
            this.cache = cache;
        }

        public void beforeCompletion() {
            if (TxInterceptor.this.log.isTraceEnabled()) {
                TxInterceptor.this.log.trace((Object)("Running beforeCompletion on gtx " + this.gtx));
            }
            this.entry = TxInterceptor.this.txTable.get(this.gtx);
            if (this.entry == null) {
                throw new IllegalStateException("cannot find transaction entry for " + this.gtx);
            }
            this.modifications = this.entry.getModifications();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            try {
                TxInterceptor.this.setInvocationContext(this.tx, this.gtx);
                if (TxInterceptor.this.log.isTraceEnabled()) {
                    TxInterceptor.this.log.trace((Object)("calling aftercompletion for " + this.gtx));
                }
                TxInterceptor.this.transactions.remove(this.tx);
                this.entry = TxInterceptor.this.txTable.get(this.gtx);
                TxInterceptor.this.getInvocationContext().setOptionOverrides(this.entry.getOption());
                switch (status) {
                    case 3: {
                        boolean onePhaseCommit;
                        boolean bl = onePhaseCommit = !this.cache.isNodeLockingOptimistic() && this.cache.getCacheModeInternal() == 2;
                        if (TxInterceptor.this.log.isDebugEnabled()) {
                            TxInterceptor.this.log.debug((Object)("Running commit phase.  One phase? " + onePhaseCommit));
                        }
                        TxInterceptor.this.runCommitPhase(this.gtx, this.modifications, onePhaseCommit);
                        TxInterceptor.this.log.debug((Object)"Finished commit phase");
                        break;
                    }
                    case 1: 
                    case 4: {
                        TxInterceptor.this.log.debug((Object)"Running rollback phase");
                        TxInterceptor.this.runRollbackPhase(this.gtx, this.modifications);
                        TxInterceptor.this.log.debug((Object)"Finished rollback phase");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("illegal status: " + status);
                    }
                }
                Object var4_3 = null;
                TxInterceptor.this.txTable.remove(this.gtx);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                TxInterceptor.this.txTable.remove(this.gtx);
                TxInterceptor.this.txTable.remove(this.tx);
                TxInterceptor.this.scrubInvocationCtx(true);
                throw throwable;
            }
            TxInterceptor.this.txTable.remove(this.tx);
            TxInterceptor.this.scrubInvocationCtx(true);
        }

        public String toString() {
            return "TxInterceptor.RemoteSynchronizationHandler(gtx=" + this.gtx + ", tx=" + this.tx + ")";
        }
    }
}

